(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   4912923,      86292]
NotebookOptionsPosition[   4905660,      86187]
NotebookOutlinePosition[   4906094,      86204]
CellTagsIndexPosition[   4906051,      86201]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Sample playground", "Title",
 CellChangeTimes->{{3.8601397412505856`*^9, 
  3.860139755017807*^9}},ExpressionUUID->"d0e8ddea-97d3-4359-93ee-\
9734776dce2c"],

Cell[TextData[{
 "This notebook is used for the processing and fitting of one sample. It \
requires the functions in ",
 StyleBox["Polydisp fitting functions all data.nb",
  FontSlant->"Italic"],
 ".\nIntensity units are arbitrary as the patterns are rescaled for merging."
}], "Text",
 CellChangeTimes->{{3.8601397453382463`*^9, 3.8601397964528313`*^9}, {
  3.8617669288125243`*^9, 3.861766945139561*^9}, {3.8617673062268524`*^9, 
  3.8617673066939745`*^9}, {3.861942912912383*^9, 
  3.861942913146066*^9}},ExpressionUUID->"7c1a7862-4493-4bbd-ad86-\
2d905071e2e2"],

Cell[CellGroupData[{

Cell["Select and plot the data to be analyzed", "Subsubsection",
 CellChangeTimes->{{3.854421099868669*^9, 3.854421101948415*^9}, {
  3.8601398442554398`*^9, 
  3.8601398549474306`*^9}},ExpressionUUID->"44c23e06-c6ba-4d87-ae3e-\
52595994b93e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Join", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Cases", "[", 
    RowBox[{
     RowBox[{"Keys", "[", "sampleFiles", "]"}], ",", 
     RowBox[{"s_String", "/;", 
      RowBox[{"StringMatchQ", "[", 
       RowBox[{"s", ",", "\"\<C16_*\>\""}], "]"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Cases", "[", 
    RowBox[{
     RowBox[{"Keys", "[", "sampleFiles", "]"}], ",", 
     RowBox[{"s_String", "/;", 
      RowBox[{"StringMatchQ", "[", 
       RowBox[{"s", ",", "\"\<BG25_*\>\""}], "]"}]}]}], "]"}]}], 
  "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"testsamples", "=", "%"}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"testsamples", "=", 
     RowBox[{"{", 
      RowBox[{
      "\"\<171_1.4002\>\"", ",", "\"\<171_30.9999\>\"", ",", 
       "\"\<171_9.99982\>\"", ",", "\"\<171_9.99999\>\""}], "}"}]}], ";"}], 
   "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.843296948142498*^9, 3.843296958212912*^9}, {
   3.8432972784145517`*^9, 3.8432973057271643`*^9}, {3.8432977131560783`*^9, 
   3.843297716018899*^9}, {3.843298309901671*^9, 3.84329834918407*^9}, 
   3.843298997733918*^9, {3.8432990321174*^9, 3.843299072004407*^9}, {
   3.843299122424327*^9, 3.843299133661518*^9}, {3.843299265884342*^9, 
   3.84329926858108*^9}, {3.843300103749148*^9, 3.843300112466827*^9}, {
   3.8527849855621357`*^9, 3.852784994200242*^9}, {3.852787417047249*^9, 
   3.852787424091958*^9}, {3.8527874789702*^9, 3.8527874801375923`*^9}, {
   3.852787728214538*^9, 3.852787778738393*^9}, {3.8527968489630823`*^9, 
   3.8527968515622187`*^9}, {3.8527969362639837`*^9, 3.852796936383173*^9}, {
   3.8527970088774014`*^9, 3.8527970089163847`*^9}, {3.853836617160633*^9, 
   3.853836617592147*^9}, {3.854421141973649*^9, 3.854421142035899*^9}, {
   3.8544211928939333`*^9, 3.854421193010366*^9}, {3.860120705408345*^9, 
   3.860120705446088*^9}, {3.8617632879814606`*^9, 3.861763304765732*^9}, {
   3.8617673092767124`*^9, 3.8617673185406885`*^9}, {3.8859734491964083`*^9, 
   3.885973455500765*^9}, {3.8859747794365234`*^9, 3.8859748137649736`*^9}, {
   3.8859750181935196`*^9, 3.885975018432844*^9}, {3.8859763176629515`*^9, 
   3.8859763198468237`*^9}, {3.8859770271978893`*^9, 
   3.8859770297569485`*^9}, {3.8859774963407874`*^9, 3.885977500029621*^9}, {
   3.8859790256696296`*^9, 3.8859790880678005`*^9}, {3.8859792862203617`*^9, 
   3.885979303353922*^9}, {3.885979636059869*^9, 3.885979636325242*^9}, {
   3.8859798673963566`*^9, 3.885979867979951*^9}, {3.8859802087472224`*^9, 
   3.8859802091063414`*^9}, 3.8859802670443172`*^9, {3.8859805336112413`*^9, 
   3.8859805370509305`*^9}, {3.885980676883481*^9, 3.8859806770585265`*^9}, {
   3.8860615694895253`*^9, 3.8860615965610476`*^9}, {3.8902035063775234`*^9, 
   3.8902035070815973`*^9}, {3.8914267029333563`*^9, 
   3.8914267032050333`*^9}, {3.9023122334032545`*^9, 3.902312234127159*^9}},
 CellLabel->
  "In[1690]:=",ExpressionUUID->"288b6ba3-0e36-41d8-949e-a2c664f880eb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"C16_30.7138\"\>", ",", "\<\"C16_10.0042\"\>", 
   ",", "\<\"C16_1.504\"\>", ",", "\<\"BG25_30.7138\"\>", 
   ",", "\<\"BG25_10.0042\"\>", ",", "\<\"BG25_1.504\"\>"}], "}"}]], "Output",
 CellChangeTimes->{{3.85278774182577*^9, 3.8527877823161783`*^9}, 
   3.852796852362589*^9, 3.852796937189692*^9, 3.852797010008708*^9, 
   3.8528624946560097`*^9, 3.853381366643115*^9, 3.853381473062273*^9, 
   3.8534022376061707`*^9, 3.85346909236896*^9, 3.8534962759553757`*^9, 
   3.8534996218158073`*^9, 3.853817842919454*^9, 3.853818242802884*^9, 
   3.853824682294836*^9, 3.853824869851644*^9, 3.853833074084684*^9, 
   3.853836452539434*^9, 3.8538366226871643`*^9, 3.8538385385329847`*^9, 
   3.854072553810278*^9, 3.85409167434895*^9, 3.854098459654634*^9, 
   3.854420757546021*^9, 3.854421148417843*^9, 3.8544211935109262`*^9, 
   3.8544236425084476`*^9, 3.860120714271991*^9, {3.8601208146323557`*^9, 
   3.860120817823097*^9}, 3.8601209904370317`*^9, {3.8601401966367846`*^9, 
   3.8601402016808*^9}, {3.8601411929801598`*^9, 3.860141197066132*^9}, 
   3.8617633119613857`*^9, 3.8617673196071157`*^9, 3.861941017862147*^9, 
   3.8619433170388165`*^9, 3.861950007077615*^9, 3.861950097594084*^9, 
   3.861950313053934*^9, 3.8859734561647086`*^9, 3.8859735723144336`*^9, {
   3.8859747343360167`*^9, 3.8859747430702314`*^9}, 3.8859747970713787`*^9, 
   3.8859750198706293`*^9, 3.885976323503401*^9, 3.8859770304553003`*^9, 
   3.885977536755321*^9, {3.885979057328891*^9, 3.885979092434539*^9}, {
   3.8859792905705223`*^9, 3.885979306593282*^9}, 3.8859796400840683`*^9, 
   3.885979871667265*^9, 3.8859802113912177`*^9, 3.8859802706713324`*^9, 
   3.885980540538966*^9, 3.8859806802452884`*^9, 3.886061601230296*^9, 
   3.8861522211573744`*^9, 3.8883109765610237`*^9, 3.8890022652170677`*^9, 
   3.8890603226490602`*^9, 3.88906456673145*^9, 3.889081912662714*^9, 
   3.88908274923429*^9, 3.889084479032218*^9, {3.8895035587135143`*^9, 
   3.8895035763897266`*^9}, 3.8895042359682283`*^9, 3.889668723612721*^9, 
   3.890203509837488*^9, 3.89020358352724*^9, 3.8909804837292213`*^9, 
   3.89098153769302*^9, 3.890982738443742*^9, 3.8914160072605443`*^9, 
   3.891426705322385*^9, 3.8926185843467875`*^9, 3.8926186672660875`*^9, 
   3.892628498999962*^9, 3.9023104802325535`*^9, {3.9023108894335456`*^9, 
   3.902310908809727*^9}, 3.9023109681024218`*^9, 3.9023122363442397`*^9},
 CellLabel->
  "Out[1690]=",ExpressionUUID->"cae87c47-cfa2-4851-8687-3c30d1d20c08"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"dataToPlot", "=", 
   RowBox[{"scatteringDataSampleAveraged", "/@", "testsamples"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"plotDataRaw", " ", "=", " ", 
  RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
   RowBox[{"dataToPlot", ",", "\[IndentingNewLine]", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"PlotLegends", "\[Rule]", "testsamples"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"FrameTicks", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
         RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
         RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",", 
    " ", 
    RowBox[{"(*", " ", 
     RowBox[{
     "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
      " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
      "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ","}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Automatic", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"5", " ", 
          RowBox[{"10", "^", 
           RowBox[{"-", "3"}]}]}], ",", 
         RowBox[{"10", "^", "5"}]}], "}"}]}], "}"}]}], ",", " ", 
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.01", ",", " ", "0.1", ",", " ", "1"}], "}"}], ",", 
        RowBox[{"{", "Automatic", "}"}], ",", " ", "None", ",", " ", "None"}],
        "}"}], ",", " ", 
      RowBox[{"FrameTicks", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
        "LogTicks", ",", "LinTicks", ",", " ", "None", ",", " ", "None"}], 
        "}"}]}]}], " ", " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"FrameLabel", " ", "->", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
      "}"}]}]}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
      "\"\<DataRaw.pdf\>\""}], "}"}], "]"}], ",", "plotDataRaw"}], " ", 
  "]"}]}], "Input",
 CellChangeTimes->{{3.84329809635746*^9, 3.843298105573452*^9}, {
   3.84329815837682*^9, 3.843298163080853*^9}, {3.843298211914578*^9, 
   3.8432982378108053`*^9}, {3.843298288845417*^9, 3.843298291452414*^9}, 
   3.843298361191868*^9, {3.84329871517915*^9, 3.843298719649724*^9}, {
   3.843299850907208*^9, 3.843299962957724*^9}, {3.843300008752656*^9, 
   3.8433000099440603`*^9}, {3.8433000666678867`*^9, 3.843300081842258*^9}, 
   3.8433001270605783`*^9, 3.852785029476323*^9, {3.8527875156086903`*^9, 
   3.852787529623748*^9}, {3.852787908039447*^9, 3.852787908637274*^9}, {
   3.88951548143122*^9, 3.88951548156557*^9}, {3.8896687353498526`*^9, 
   3.8896687417207317`*^9}, {3.8896725688232393`*^9, 3.889672590126113*^9}, {
   3.889672623190502*^9, 3.8896726983115826`*^9}, {3.889672740640524*^9, 
   3.889672758876796*^9}, {3.8896729834503565`*^9, 3.889673069010479*^9}, {
   3.889673142722207*^9, 3.8896731964734883`*^9}, {3.889676349237294*^9, 
   3.8896763709122796`*^9}, {3.889692253576544*^9, 3.889692254563936*^9}},
 CellLabel->
  "In[1692]:=",ExpressionUUID->"6ebf2b6c-fd73-4115-90fc-264fde664a3f"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUV3k4lV8XvfM1z1OGUhFRQiFU76WIypBEKkrqF5WIilKiDGWsaCJThIqi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         "]], 
        LineBox[{{-1.4454980484729534`, -5.298317366548036}, \
{-1.4450009727872855`, -3.166135977008875}, {-1.4443601798882761`, \
-2.490209769758544}, {-1.4437197342142167`, -3.182749323180701}, \
{-1.4430797615355704`, -3.5356376918664956`}, {-1.4424401351130984`, \
-3.7900516742169814`}, {-1.4418009805577212`, -3.113422088165872}, \
{-1.4411621712935578`, -2.6359081223198237`}, {-1.4405238327723882`, \
-2.913743395110569}, {-1.4399527235694527`, -5.298317366548036}}], 
        LineBox[{{-1.4397898119397985`, -5.298317366548036}, \
{-1.4392483140132346`, -3.7235175567109122`}, {-1.438611132817861, \
-2.927326444241354}, {-1.4379744201298463`, -2.8775749018164896`}, \
{-1.437338049860857, -2.2753719398567216`}, {-1.4367021469876509`, \
-3.15704701726647}, {-1.4360665855835733`, -3.3036319824384566`}, \
{-1.4354314904678365`, -3.0123168478402995`}, {-1.4347967358750486`, \
-3.0861531889725677`}, {-1.434162446467272, -2.4887587712472317`}, \
{-1.433528496639963, -3.005843621138101}, {-1.4328950108984277`, \
-2.9386741498337106`}, {-1.4322618637985587`, -4.992750768013108}, \
{-1.4316291796892966`, -2.978525287366707}, {-1.43099683328656, \
-3.0996885477601426`}, {-1.4303649487833152`, -2.9631689122539053`}, \
{-1.4297334010550968`, -4.616868230251652}, {-1.4294378586537886`, \
-5.298317366548036}}], 
        LineBox[{{-1.4289382927846943`, -5.298317366548036}, \
{-1.428471563070626, -3.096765874108608}, {-1.4278412717313003`, \
-2.7876513496838466`}, {-1.4272113153148538`, -2.2698304803120952`}, \
{-1.4265817554936695`, -3.517728133960477}, {-1.4262440916802015`, \
-5.298317366548036}}], 
        LineBox[CompressedData["
1:eJwB8QEO/iFib1JlAgAAAB4AAAACAAAAM9i6Lp3P9r9TnJQbejEVwDAML2sg
zva/yVo9EouUCcDFLzOWjcv2v7AcDEDb/wvABFaBGvvI9r/LGvqprqQUwLV+
NRlpxva/K7rTw5m9CsCHAfVw18P2v+Q2o/zetgjAY1LRQkbB9r+wPYSwtnQM
wNKSem21vva/z7jz94g5DcCKsfcRJbz2v3tvhIngqQnA8ZIDD5W59r+J4+4M
GCEIwDKnmoUFt/a/DBo0q/5bBcCWjoJUdrT2vz5tU7EVDQvAYUGtnOex9r+q
2GXo2gIKwM0U6zxZr/a/mC0X/QB2CcDTjyNWy6z2vzcISWwBeQHAs7Uxxz2q
9r/uc/iR5OUFwLCi8rCwp/a/pE/BVd3TC8AsAUzyI6X2v/BgBUtx2gXAQ4kQ
rJei9r84hyEvtQAGwJ6FML0LoPa/TLdnb2+FDsC6UHRGgJ32v7gru1uRlwTA
r87WJvWa9r9GBamSpg0IwOACFn9qmPa/p1NOdG0DA8ACZDcu4JX2v7DXa0wm
3ALA3KTuVFaT9r81nPLImWEOwPfHS9LMkPa/zmO2JKXPBsDzNfjGQ472v5Ji
4g0zWgjAbHYOEruL9r9iCWLQfL0IwEyuLdQyifa/vliXVWZmCsAXy05+uIf2
v1OclBt6MRXA2koBkA==
         "]], 
        LineBox[{{-1.406643273505007, -4.454255666257608}, \
{-1.4060265870799868`, -3.453063935854143}, {-1.4054102199677423`, \
-4.979503088720985}, {-1.4047942932474957`, -2.507358790531257}, \
{-1.404245489341634, -5.298317366548036}}], 
        LineBox[{{-1.404119836726194, -5.298317366548036}, \
{-1.4035635160942912`, -2.0866348178499075`}, {-1.4029486648038185`, \
-3.461058437332248}, {-1.4023342518915736`, -3.2087343073785903`}, \
{-1.4017201557195431`, -2.6714419052616822`}, {-1.4011064969242768`, \
-2.48024718364735}, {-1.4004931540181937`, -2.9927777090690673`}, \
{-1.3998802474910017`, -3.0560470103836734`}, {-1.3992676560051798`, \
-2.1375359086227235`}, {-1.398655499903949, -2.7989642985765206`}, \
{-1.398043657999477, -4.880194754013574}, {-1.3974322504888532`, \
-4.616952090512714}, {-1.3968211563335622`, -2.3292252771533715`}, \
{-1.3962104955849148`, -1.9542882586043604`}, {-1.3956001473533453`, \
-4.123392605556917}, {-1.394990231544737, -4.049979846953196}, \
{-1.3943806274181056`, -2.890000704384805}}], 
        LineBox[{{-1.3930675453168115`, -5.298317366548036}, \
{-1.3925541015537621`, -2.549932553674646}, {-1.3919460401861279`, \
-4.676910073370585}, {-1.391338288426397, -2.4828993693068533`}, \
{-1.3907309656742075`, -3.289241492059982}, {-1.3901239517057393`, \
-2.533314893991816}, {-1.3895173657767712`, -1.6362728623638434`}, \
{-1.3889110878104278`, -4.843844836551239}}], 
        LineBox[{{-1.387699693172116, -2.664180639559222}, \
{-1.3870945755389497`, -2.8012683258236457`}}], 
        LineBox[{{-1.3852813570020988`, -3.9950589490361006`}, \
{-1.3846776410293211`, -1.8000242573817236`}, {-1.3840742893096247`, \
-1.7355727782561938`}, {-1.3834713014037296`, -3.202116315239425}, \
{-1.382868795674771, -1.9020825897139253`}, {-1.382266534010283, \
-2.0095688286885776`}}]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUW3k81O8TX/da1y7KnSMpd4VQaSVRKiWUXCnkSKGSUpSjcpSUKCp9iUSE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         "]], 
        LineBox[CompressedData["
1:eJwBYQKe/SFib1JlAgAAACUAAAACAAAAO+A/tMMf0r9TnJQbejEVwDkBM0Ez
F9K/D/Zcfu5XE8DlkTGyHg3Sv5OCYdAHkRLA+3NjuQsD0r9tWXpGB8sRwPXT
CKv6+NG/DU2tI0PnEcAG3RTd6u7Rv2zy2Cj0SBPAIYrVo9zk0b9hQEi0Jw4T
wHrTY1PQ2tG/bAPUxT1dFMAHdgNCxdDRv4cWeO6w1BPABSvbw7vG0b9/bI7a
1cITwJTa3Cy0vNG/dER61RHzEcACh5zTrbLRv3xXd4Sy9xHAGswZDKmo0b/U
IxDgd0ASwOqlHyqmntG/q+M7UY8WFMAWEJKEpJTRvwV6i5d2ohPADq1Jb6SK
0b8DxFsiA2cSwJew6j2mgNG/NQncrysOE8AcxKhHqXbRv44zTTvu9xLAkbQ1
4K1s0b/4Q+bacUgTwBQRD1u0YtG/VzRXvHA2E8Cr5bcPvFjRv+pI0q/8/BHA
gE27UcVO0b8uzlwB6oMTwHdWcHTQRNG/V16QnAr6EsByJKnP3DrRv20igAWw
0hPAU0TKtuow0b/XK4jGChkTwP5lBH36JtG/GSeHTgtKEsDhenh6Cx3RvwdG
hmWK2xTA4qRkAh4T0b/hXowAw28TwPNY02cyCdG/+t+ong/VEsAiDDQDSP/Q
vxiLvtHH5BPAepieJ1/10L/iptfy5JUTwNZa9yd469C/e8Y1iwbuEMBhAvxc
kuHQvxacaPbzYxPAPESeGa7X0L96fDYylxITwNqHnLDLzdC/EmQ9c4v2EsBk
bQJ76sPQv82r70CAehPAUHm+vfe/0L9TnJQbejEVwKRwNSw=
         "]], 
        LineBox[{{-0.2610016462028551, -5.298317366548036}, \
{-0.26075290609440566`, -4.845556294473597}, {-0.26015098443578805`, \
-4.152896081056703}, {-0.2595494248689136, -4.148169766499448}, \
{-0.259132214505617, -5.298317366548036}}]}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJw8m3c8l+0Xx+29vyohEqJktDyhOhItDStCIRlFKhKRhDSMUiGVIlGRZCQk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         "]]}, {
        Hue[0.37820393249936934`, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.922526, 0.385626, 0.209179], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUV3c8lf8Xv3svW1RERkhIZd9LZSYkZURJSkmkIqlERltJKErFFylFiSie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         "]], 
        LineBox[CompressedData["
1:eJw9VXs81HkXJol1mfn9ZohqSYnaVjFha9uwNC7pjVxKF0XETrFZUVFEW2Fd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         "]], 
        LineBox[CompressedData["
1:eJwBMQLO/SFib1JlAgAAACIAAAACAAAAA1e6lA9s+L9TnJQbejEVwP7vBVJt
afi/KwexYvqTEMBuhDfZlGb4v4G41IfQEhHANWY/9Lxj+L+sTbaTXd0TwCiY
L37lYPi/6QwJmIU6EcDHspObDl74v9Oj2P5p8Q7AF/WKJzhb+L8tWq4rcxIR
wK8hlEZiWPi/VLcPJobEEMBCqtvTjFX4v/kp0z8iGhLAcYTT87dS+L9ro26C
/n4QwCJLtYHjT/i/xdbTyN3dDcDwL+ahD034v/XH368rDhDAgu2sLzxK+L9s
8ilfsAoTwE36YU9pR/i/kG1RpE0FFcBXJ1nclkT4v47sEZ/pjRLAyDje+sRB
+L/tYxK54HkQwKgMUobzPvi/orxxmXVxEcCjvfOiIjz4v/dhaL/Fuw/Aci0x
LFI5+L8dJs2vqwYOwAvWPEaCNvi/yn5AxbdUDsCRk5HMsjP4v9Ah3vg3ShHA
BEhV4+Mw+L8BEwbWHIATwK/AD2YVLvi/NlmOEQlEE8BVUNp4Ryv4vwJeC/x4
sxHAN6xJ93ko+L9O+LCJR7QQwIGgagWtJfi/lFwCVvRFEsBEwd5+4CL4v99e
iR6cixHAulymhxQg+L84SH4K5x0RwKDcb/tIHfi/ggzFBxPVD8DaGS/+fRr4
v7E38w/zPBDAvEqfa7MX+L9MRfarZx0VwGTbp2fpFPi/W0ml1bVpFMCvxRDO
HxL4v7pfJnm8MRHAS515al4P+L9TnJQbejEVwMkMGbo=
         "]], 
        LineBox[{{-1.5037373115477313`, -5.298317366548036}, \
{-1.5030652337220112`, -4.331103292784053}, {-1.5023861452440905`, \
-5.176982644281236}, {-1.5017074507178931`, -5.233671505510157}, \
{-1.501029283356703, -4.187777142744001}, {-1.500351508788963, \
-5.122999128780635}, {-1.49967426004908, -3.9248989701165513`}, \
{-1.4989974029491981`, -4.94981402959598}, {-1.4983210703453254`, \
-3.970192279352568}, {-1.4976451282328034`, -4.509504977213211}, \
{-1.497282419903845, -5.298317366548036}}], 
        LineBox[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAApneL4K/y979TnJQbejEVwHlwp7DS
8Pe/oCqk+TMhD8Dl+dtqD+73v0LfRKfBaxDAq/xFjUzr97+wKLB5IB4QwCSv
ajuK6Pe/iztDK8POEMAu5nZRyOX3v6NI1Xw7PxTA/88W4Qbj97/taga8RD0U
wBZq6vtF4Pe/1HrsTwxPE8DKMzF+hd33v3fKU7yUUg7A2R9Si8Xa97/4atrb
9LMPwFwUmf8F2Pe/arFhx2pfFMBr92D+RtX3v0BwMCS87hTAPA0CZIjS979q
SzeSOZEPwGg3y1PKz/e/hxvGkWfoDMCsDyGqDM33v8dW61hyCRXAQHtGik/K
978Vo+tpvI0RwNlgrNCSx/e/Z/RZdD4eEcBksYmg1sT3v6Zq+TaG0w3ACJhb
1hrC97/p9UiKYJYQwO8768mUwPe/U5yUG3oxFcBLt7NN
         "]], 
        LineBox[{{-1.483886653499008, -5.298317366548036}, \
{-1.4835555326370005`, -4.39705131516282}, {-1.4828895602005607`, \
-4.401750227067394}, {-1.482223965382512, -4.374087933670677}, \
{-1.4815588788483816`, -3.9384168175040464`}, {-1.4812637138944458`, \
-5.298317366548036}}], 
        LineBox[{{-1.4803310403373955`, -5.298317366548036}, \
{-1.4802299658562001`, -4.992724114168252}, {-1.480130607317852, \
-5.298317366548036}}], 
        LineBox[{{-1.4790167876091118`, -5.298317366548036}, \
{-1.4789028165302598`, -4.938134008965426}, {-1.478239869107999, \
-5.0622434804610075`}, {-1.4775774261954666`, -3.3915402251370703`}, \
{-1.4769153565646709`, -4.558825204390678}, {-1.4762537901952915`, \
-5.058448137319012}, {-1.4755925960345126`, -4.0385819735202935`}, \
{-1.4749775546448352`, -5.298317366548036}}], 
        LineBox[{{-1.4746371640347773`, -5.298317366548036}, \
{-1.4742715828886581`, -5.1823414383079065`}, {-1.4736117626649108`, \
-4.982317778518238}, {-1.4729523125165611`, -3.931031150665172}, \
{-1.4722933619135883`, -3.726149987245192}, {-1.4716347803258993`, \
-3.82044712941299}, {-1.4709766970544564`, -4.794451356971668}, \
{-1.470569512613433, -5.298317366548036}}], 
        LineBox[{{-1.4699900741939378`, -5.298317366548036}, \
{-1.4696617635223481`, -4.988863228633127}, {-1.4690049122101352`, \
-4.9862082416072315`}, {-1.4683990314453386`, -5.298317366548036}}], 
        LineBox[{{-1.4683340010489607`, -5.298317366548036}, \
{-1.467692567190646, -4.152511638544663}, {-1.467037072268365, \
-4.16446176460503}, {-1.4663819421636302`, -4.217548623597961}, \
{-1.4657273055057047`, -4.7324541834001455`}, {-1.465073032626457, \
-3.4151974642051353`}, {-1.4647478434084786`, -5.298317366548036}}], 
        LineBox[{{-1.4639294832167207`, -5.298317366548036}, \
{-1.4637658340941535`, -4.6625171875140605`}, {-1.4635861917095527`, \
-5.298317366548036}}], 
        LineBox[{{-1.4626413805310627`, -5.298317366548036}, \
{-1.4624603420993125`, -4.655187661493137}, {-1.4622737460920365`, \
-5.298317366548036}}], 
        LineBox[{{-1.4603921544184328`, -5.298317366548036}, \
{-1.4598544599396643`, -3.3016071198731365`}, {-1.459204016997299, \
-4.681394983523469}, {-1.458630550877732, -5.298317366548036}}], 
        LineBox[{{-1.4573737786764684`, -5.298317366548036}, \
{-1.4572553507560915`, -4.6081576337074575`}, {-1.4570061472398073`, \
-5.298317366548036}}], 
        LineBox[{{-1.4562430340056267`, -5.298317366548036}, \
{-1.455958325045854, -4.431771799698098}, {-1.4553104105673174`, \
-3.6884219517704806`}, {-1.4546629794324164`, -3.7875887872405443`}, \
{-1.454015903412415, -4.424856977366221}, {-1.4533693095687956`, \
-4.779929861161433}, {-1.4527230698400555`, -4.210198452513272}, \
{-1.4520773111248584`, -4.726138237648436}, {-1.4514319055284977`, \
-3.809659189144794}, {-1.4507869797872333`, -3.6576939636188914`}}], 
        LineBox[{{-1.4494595020042143`, -5.298317366548036}, \
{-1.4488545674843287`, -4.88190758788891}, {-1.4482113012607243`, \
-4.991634932671452}, {-1.4475683851914845`, -4.404280576219742}, \
{-1.446925945528132, -5.058222512174203}, {-1.4465574513315533`, \
-5.298317366548036}}], 
        LineBox[{{-1.4462147731221693`, -5.298317366548036}, \
{-1.445642239814265, -3.820915009826304}, {-1.4450009727872855`, \
-4.487892130493094}, {-1.4443601798882761`, -3.689620948818113}, \
{-1.4437197342142167`, -4.1859897494254525`}, {-1.4430797615355704`, \
-4.521661853962425}, {-1.4424401351130984`, -3.4512697536520935`}, \
{-1.4418009805577212`, -4.25023259330421}, {-1.4416042175553077`, \
-5.298317366548036}}], 
        LineBox[{{-1.4406928177346845`, -5.298317366548036}, \
{-1.4405238327723882`, -4.450565730070384}, {-1.4401712215799982`, \
-5.298317366548036}}], 
        LineBox[{{-1.4396163915314673`, -5.298317366548036}, \
{-1.4392483140132346`, -4.3610435177695415`}, {-1.438611132817861, \
-4.873463190028933}, {-1.4379744201298463`, -3.9908319487200803`}, \
{-1.437387973634555, -5.298317366548036}}], 
        LineBox[{{-1.4347967358750486`, -4.651005338914097}, \
{-1.434162446467272, -5.125227008565867}}], 
        LineBox[{{-1.4328950108984277`, -4.356067813256831}, \
{-1.4322618637985587`, -4.393001183791281}, {-1.4316291796892966`, \
-4.893982783803193}, {-1.4313152749202462`, -5.298317366548036}}], 
        LineBox[{{-1.429102314139286, -3.7975380561614918`}, \
{-1.428471563070626, -3.5806928834518836`}, {-1.428054099927964, \
-5.298317366548036}}], 
        LineBox[{{-1.427063380108268, -5.298317366548036}, \
{-1.4265817554936695`, -3.3967932259575795`}, {-1.42595265378466, \
-5.001251158093977}, {-1.4253238856188197`, -3.9803091493548735`}, \
{-1.424695574492021, -2.7125261171725916`}, {-1.4240675959930522`, \
-4.565336714721569}, {-1.423440073463934, -3.5096303820731847`}, \
{-1.4230640573350464`, -5.298317366548036}}], 
        LineBox[{{-1.4205899318224064`, -5.298317366548036}, \
{-1.4203081690295074`, -3.935636994726556}, {-1.4196830004606906`, \
-3.9113641821774228`}, {-1.4193428567564446`, -5.298317366548036}}], 
        LineBox[{{-1.4178097133274605`, -4.0750369361463985`}, \
{-1.4171861042786886`, -3.1460246966053}, {-1.4165628224394424`, \
-3.514548710088936}, {-1.4159399902365912`, -3.9104830761884}, \
{-1.4153650725124158`, -5.298317366548036}}], 
        LineBox[{{-1.4143543716746851`, -5.298317366548036}, \
{-1.414073695203434, -3.778047679104936}, {-1.4137264541023669`, \
-5.298317366548036}}], 
        LineBox[{{-1.4096183420134631`, -5.298317366548036}, \
{-1.4091139512378517`, -3.6865429357371795`}, {-1.408759986598989, \
-5.298317366548036}}], 
        LineBox[{{-1.4082412080315263`, -5.298317366548036}, \
{-1.407877849340566, -3.580615504897623}, {-1.40746819022165, \
-5.298317366548036}}], 
        LineBox[{{-1.4070536129033233`, -5.298317366548036}, \
{-1.406643273505007, -3.569438934928174}, {-1.4060265870799868`, \
-3.9277720571367136`}, {-1.4054102199677423`, -4.234246477078686}}], 
        LineBox[{{-1.403562249878592, -5.298317366548036}, \
{-1.4029486648038185`, -3.50232074803919}, {-1.4027706951203969`, \
-5.298317366548036}}], 
        LineBox[{{-1.400840577054237, -5.298317366548036}, \
{-1.4004931540181937`, -3.1121560601199656`}, {-1.3998802474910017`, \
-3.325239376225763}}], 
        LineBox[{{-1.398655499903949, -4.120282342546367}, \
{-1.398043657999477, -3.557972110479627}}], 
        LineBox[{{-1.3931625929004259`, -5.250416840132505}, \
{-1.3925541015537621`, -2.861298478622127}, {-1.3919460401861279`, \
-3.31801981184503}, {-1.391338288426397, -3.493553549565278}}], 
        LineBox[{{-1.3895173657767712`, -3.6246956952954177`}, \
{-1.3889110878104278`, -2.8870540138682053`}}], 
        LineBox[{{-1.4308119554125818`, -5.298317366548036}, \
{-1.4303649487833152`, -4.306568202162434}}]}, {
        Hue[0.6142719099991583, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.528488, 0.470624, 0.701351], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUWnc81e8Xt/e891pJkpE9olBkJBIZaZDxLRSJRImyQnZJWkhUFIpQRBnn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         "]], 
        LineBox[{{-0.274677743164378, -5.298317366548036}, \
{-0.27408705585431015`, -4.969485974757601}, {-0.273598930718067, \
-5.298317366548036}}], 
        LineBox[{{-0.2721308661865039, -5.298317366548036}, \
{-0.27164944546190495`, -5.099040171584874}, {-0.2710409310817236, \
-4.827102489230139}, {-0.27043278676611493`, -5.190183761590067}, \
{-0.27011722996158055`, -5.298317366548036}}], 
        LineBox[{{-0.2692932393090027, -5.298317366548036}, \
{-0.2692176845490116, -5.284095850375458}, {-0.268610647684061, \
-4.678386890519318}, {-0.26800405701359853`, -4.410781081388414}, \
{-0.2673977561952779, -4.831118370141682}, {-0.2671970924629547, \
-5.298317366548036}}], 
        LineBox[{{-0.2656315760385054, -5.298317366548036}, \
{-0.26558113396476035`, -5.285816629941033}, {-0.26497629994481253`, \
-4.720271339889647}, {-0.2643719091696942, -5.228139952607627}, \
{-0.26376780586728016`, -5.03739343249013}, {-0.26316406728534836`, \
-5.08188885025199}, {-0.262560770485036, -5.087528578106296}, \
{-0.26195775997776694`, -4.836499833344438}, {-0.26135511287304525`, \
-4.633771593023157}, {-0.26075290609440566`, -4.760675184375608}, \
{-0.26015098443578805`, -4.607324334564698}, {-0.2595494248689136, \
-4.364465508880019}, {-0.25894830418020226`, -3.4429375320786066`}}]}, {
        Hue[0.8503398874989481, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.772079, 0.431554, 0.102387], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwcW3c8Vf8bt0cq4mqhpZCVFGU+9KVFEcrILKVsESmpNFFRRlZKIrOEklHn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         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {-6.487195066484062, -5.298317366548025}, DisplayFunction :> 
     Identity, Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
        FormBox[
         TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameTicks -> {{{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           
           TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           
           TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           
           TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           
           TemplateBox[{"10", "5"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000], 12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000], 12.611537753638338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000], 12.89921982609012], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000], 13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000], 13.304684934198283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000], 13.458835614025542`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000], 13.592367006650065`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000], 13.710150042306449`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000], 12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000], 12.611537753638338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000], 12.89921982609012], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000], 13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000], 13.304684934198283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000], 13.458835614025542`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000], 13.592367006650065`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000], 13.710150042306449`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}, {{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[1, 0.75, 0], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.647624, 0.37816, 0.614037], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.571589, 0.586483, 0.], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.915, 0.3325, 0.2125], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[
          0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
          AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
       "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
       Scaled[0.05], "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> 
       True, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-6.487195066484062, 
      1.6310721412512184`}, {-5.298317366548036, 11.512925464970229`}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {0, 0}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], 
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0]}}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "\"C16_30.7138\"", "\"C16_10.0042\"", "\"C16_1.504\"", 
       "\"BG25_30.7138\"", "\"BG25_10.0042\"", "\"BG25_1.504\""}, 
      "PointLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #3}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #4}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #5}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #6}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontSize -> 14, 
          GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.880722, 0.611041, 0.142051]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.560181, 0.691569, 0.194885]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.922526, 0.385626, 0.209179]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.528488, 0.470624, 0.701351]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.772079, 0.431554, 0.102387]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5, ",", #6}], "}"}], 
           ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               
               RowBox[{
                "True", ",", "True", ",", "True", ",", "True", ",", "True", 
                 ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.843298149991452*^9, 3.843298203872168*^9, 3.8432982736696587`*^9, {
   3.843298384765218*^9, 3.843298404726954*^9}, 3.84329873022256*^9, {
   3.8432988004009867`*^9, 3.843298803824133*^9}, {3.843298872108584*^9, 
   3.843298895599083*^9}, {3.8432990149186*^9, 3.8432990770538588`*^9}, {
   3.843299137189081*^9, 3.8432991407725573`*^9}, {3.843299840648491*^9, 
   3.843299921480537*^9}, {3.843299960469057*^9, 3.843299972052854*^9}, 
   3.843300012041739*^9, 3.843300096769802*^9, {3.8433001291250687`*^9, 
   3.843300174678563*^9}, {3.852785009054036*^9, 3.852785030774148*^9}, {
   3.852787502594598*^9, 3.852787530539609*^9}, 3.852787791379717*^9, 
   3.852787910287105*^9, 3.852796869163835*^9, 3.8527969417886457`*^9, {
   3.852797012104776*^9, 3.852797018397952*^9}, 3.852862497566475*^9, 
   3.853381366813589*^9, 3.8533814753005857`*^9, 3.853402239868787*^9, 
   3.853469094796208*^9, 3.853496279768393*^9, 3.853499624685063*^9, 
   3.853817846160879*^9, 3.853818247955379*^9, 3.8538246853293123`*^9, 
   3.8538248725516987`*^9, 3.853833076731237*^9, 3.853836454739139*^9, 
   3.853836627576047*^9, 3.8538385410146437`*^9, 3.8540725564096527`*^9, 
   3.854091676757815*^9, 3.854098462801889*^9, 3.8544207604946127`*^9, 
   3.854421164446437*^9, 3.8544212040376797`*^9, 3.8544236563123503`*^9, 
   3.860120820146564*^9, 3.860120992755413*^9, 3.8601402097736197`*^9, 
   3.860141203197979*^9, 3.8617633271887465`*^9, 3.8617673254490795`*^9, 
   3.861941023959653*^9, 3.8619503178258157`*^9, 3.885973462316798*^9, {
   3.8859735791689806`*^9, 3.8859735863327785`*^9}, 3.8859747465859413`*^9, 
   3.8859747986681952`*^9, {3.885975027787902*^9, 3.8859750393330336`*^9}, 
   3.885976328509342*^9, 3.885977032989354*^9, 3.8859775404716673`*^9, 
   3.885979060483423*^9, 3.8859790972689905`*^9, {3.885979294595189*^9, 
   3.885979310657553*^9}, 3.885979644422537*^9, 3.8859798767472997`*^9, 
   3.8859802200758305`*^9, 3.885980276257719*^9, 3.885980545153112*^9, 
   3.885980685497188*^9, 3.8860616074751854`*^9, 3.886152225682108*^9, 
   3.888310978040262*^9, 3.889002269915166*^9, 3.8890603306392736`*^9, 
   3.889064568176372*^9, 3.889081913918378*^9, 3.8890827504249163`*^9, 
   3.889084480239011*^9, {3.8895035588509493`*^9, 3.8895035673865147`*^9}, {
   3.8895042405971904`*^9, 3.889504241091606*^9}, 3.88951548578316*^9, {
   3.8896687291557455`*^9, 3.889668742820923*^9}, 3.8896725906682463`*^9, 
   3.889672649616415*^9, 3.8896726992702703`*^9, {3.889672743456319*^9, 
   3.8896727596135435`*^9}, {3.889672989005809*^9, 3.889673014473555*^9}, 
   3.889673069643585*^9, {3.88967314352767*^9, 3.8896731597222066`*^9}, 
   3.8896731975865993`*^9, 3.8896763716560993`*^9, 3.890203528371027*^9, 
   3.8902035960444994`*^9, 3.8909804917392635`*^9, 3.8909815443374186`*^9, 
   3.8909827436668806`*^9, 3.8914160422882376`*^9, 3.8914267278210635`*^9, 
   3.8926186725375676`*^9, 3.8926285105499525`*^9, 3.9023104874576397`*^9, {
   3.902310896121235*^9, 3.9023109153619537`*^9}, 3.9023109722018175`*^9, 
   3.902312244533969*^9},
 CellLabel->
  "Out[1693]=",ExpressionUUID->"671cb89b-2a36-4542-b521-65eb64a1ceb8"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2022-08_\
new_data\\\\Analysis\\\\Full form factor fit\\\\LH-ESRF-C16 - volume (not \
corrupted)\\\\DataRaw.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.843298149991452*^9, 3.843298203872168*^9, 3.8432982736696587`*^9, {
   3.843298384765218*^9, 3.843298404726954*^9}, 3.84329873022256*^9, {
   3.8432988004009867`*^9, 3.843298803824133*^9}, {3.843298872108584*^9, 
   3.843298895599083*^9}, {3.8432990149186*^9, 3.8432990770538588`*^9}, {
   3.843299137189081*^9, 3.8432991407725573`*^9}, {3.843299840648491*^9, 
   3.843299921480537*^9}, {3.843299960469057*^9, 3.843299972052854*^9}, 
   3.843300012041739*^9, 3.843300096769802*^9, {3.8433001291250687`*^9, 
   3.843300174678563*^9}, {3.852785009054036*^9, 3.852785030774148*^9}, {
   3.852787502594598*^9, 3.852787530539609*^9}, 3.852787791379717*^9, 
   3.852787910287105*^9, 3.852796869163835*^9, 3.8527969417886457`*^9, {
   3.852797012104776*^9, 3.852797018397952*^9}, 3.852862497566475*^9, 
   3.853381366813589*^9, 3.8533814753005857`*^9, 3.853402239868787*^9, 
   3.853469094796208*^9, 3.853496279768393*^9, 3.853499624685063*^9, 
   3.853817846160879*^9, 3.853818247955379*^9, 3.8538246853293123`*^9, 
   3.8538248725516987`*^9, 3.853833076731237*^9, 3.853836454739139*^9, 
   3.853836627576047*^9, 3.8538385410146437`*^9, 3.8540725564096527`*^9, 
   3.854091676757815*^9, 3.854098462801889*^9, 3.8544207604946127`*^9, 
   3.854421164446437*^9, 3.8544212040376797`*^9, 3.8544236563123503`*^9, 
   3.860120820146564*^9, 3.860120992755413*^9, 3.8601402097736197`*^9, 
   3.860141203197979*^9, 3.8617633271887465`*^9, 3.8617673254490795`*^9, 
   3.861941023959653*^9, 3.8619503178258157`*^9, 3.885973462316798*^9, {
   3.8859735791689806`*^9, 3.8859735863327785`*^9}, 3.8859747465859413`*^9, 
   3.8859747986681952`*^9, {3.885975027787902*^9, 3.8859750393330336`*^9}, 
   3.885976328509342*^9, 3.885977032989354*^9, 3.8859775404716673`*^9, 
   3.885979060483423*^9, 3.8859790972689905`*^9, {3.885979294595189*^9, 
   3.885979310657553*^9}, 3.885979644422537*^9, 3.8859798767472997`*^9, 
   3.8859802200758305`*^9, 3.885980276257719*^9, 3.885980545153112*^9, 
   3.885980685497188*^9, 3.8860616074751854`*^9, 3.886152225682108*^9, 
   3.888310978040262*^9, 3.889002269915166*^9, 3.8890603306392736`*^9, 
   3.889064568176372*^9, 3.889081913918378*^9, 3.8890827504249163`*^9, 
   3.889084480239011*^9, {3.8895035588509493`*^9, 3.8895035673865147`*^9}, {
   3.8895042405971904`*^9, 3.889504241091606*^9}, 3.88951548578316*^9, {
   3.8896687291557455`*^9, 3.889668742820923*^9}, 3.8896725906682463`*^9, 
   3.889672649616415*^9, 3.8896726992702703`*^9, {3.889672743456319*^9, 
   3.8896727596135435`*^9}, {3.889672989005809*^9, 3.889673014473555*^9}, 
   3.889673069643585*^9, {3.88967314352767*^9, 3.8896731597222066`*^9}, 
   3.8896731975865993`*^9, 3.8896763716560993`*^9, 3.890203528371027*^9, 
   3.8902035960444994`*^9, 3.8909804917392635`*^9, 3.8909815443374186`*^9, 
   3.8909827436668806`*^9, 3.8914160422882376`*^9, 3.8914267278210635`*^9, 
   3.8926186725375676`*^9, 3.8926285105499525`*^9, 3.9023104874576397`*^9, {
   3.902310896121235*^9, 3.9023109153619537`*^9}, 3.9023109722018175`*^9, 
   3.9023122474265995`*^9},
 CellLabel->
  "Out[1694]=",ExpressionUUID->"1699bedb-0400-460e-b381-b74728031284"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Process data", "Subsubsection",
 CellChangeTimes->{{3.8601399392765074`*^9, 3.8601399407209606`*^9}, {
   3.8859798317515917`*^9, 3.885979836205883*^9}, 
   3.8896895105228753`*^9},ExpressionUUID->"c68dbf72-8a8c-4c44-a3ef-\
9c60b7918969"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Subtract", " ", "backgrounds"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"dataToAnalyze", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"scatteringDataSampleAveragedSubtracted", "[", 
        RowBox[{
        "\"\<C16_30.7138\>\"", ",", "\"\<BG25_30.7138\>\"", ",", "1.05"}], 
        "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"scatteringDataSampleAveragedSubtracted", "[", 
         RowBox[{
         "\"\<C16_10.0042\>\"", ",", "\"\<BG25_10.0042\>\"", ",", "1.05"}], 
         "]"}], ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"wat", " ", "doen", " ", "de", " ", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"1", ",", "0"}], "}"}], ",", " ", 
             RowBox[{"{", 
              RowBox[{"0", ",", "4"}], "}"}]}], "}"}], "?", " ", "--"}]}], 
         ">", " ", 
         RowBox[{
         "vermenigvuldig", " ", "alle", " ", "intensity", " ", "waardes", " ",
           "met", " ", "4"}]}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"scatteringDataSampleAveragedSubtracted", "[", 
         RowBox[{
         "\"\<C16_1.504\>\"", ",", "\"\<BG25_1.504\>\"", ",", "1.05"}], "]"}],
         ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"plotDataSubtracted", " ", "=", " ", 
    RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
     RowBox[{"dataToAnalyze", ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
        " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
        "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<31 m\>\"", ",", " ", "\"\<10 m\>\"", ",", " ", "\"\<1.5 m\>\""}],
         "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", 
         RowBox[{"{", " ", 
          RowBox[{
           RowBox[{"10", "^", 
            RowBox[{"-", "5"}]}], ",", 
           RowBox[{"10", "^", "5"}]}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}]}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<DataSubtracted.pdf\>\""}], "}"}], "]"}], ",", 
     "plotDataSubtracted"}], " ", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.852787913735702*^9, 3.852788081126293*^9}, {
   3.852788124237091*^9, 3.852788221803185*^9}, {3.85278830511749*^9, 
   3.852788314820683*^9}, 3.852788353883409*^9, {3.8527951901832237`*^9, 
   3.852795266554426*^9}, {3.852795790301991*^9, 3.852795801188776*^9}, {
   3.8534052664208517`*^9, 3.853405359776355*^9}, 3.853405404221602*^9, {
   3.853409748113482*^9, 3.8534097682258587`*^9}, 3.853410243789892*^9, {
   3.853410568646674*^9, 3.853410593142272*^9}, {3.8538366552098618`*^9, 
   3.853836688425962*^9}, {3.8544213058580093`*^9, 3.8544213392155523`*^9}, {
   3.854421399974036*^9, 3.854421487835609*^9}, {3.860120980130918*^9, 
   3.8601209825914593`*^9}, {3.8601399447486825`*^9, 3.860139952932967*^9}, {
   3.861763386455724*^9, 3.8617634066433244`*^9}, {3.8617636721585855`*^9, 
   3.8617636911551275`*^9}, 3.861763753820904*^9, {3.861763829259494*^9, 
   3.8617638295877748`*^9}, {3.8617640171756115`*^9, 
   3.8617640685814066`*^9}, {3.861764108969255*^9, 3.8617641095314784`*^9}, {
   3.8617641469152203`*^9, 3.8617641470504246`*^9}, {3.8617642667147017`*^9, 
   3.861764269211673*^9}, {3.861764301965845*^9, 3.8617643679072943`*^9}, {
   3.861764616394006*^9, 3.861764629873103*^9}, {3.8617647074999027`*^9, 
   3.861764707889408*^9}, {3.861767331688716*^9, 3.8617674531915107`*^9}, {
   3.8619430250008717`*^9, 3.8619430252780623`*^9}, 3.885975125250722*^9, {
   3.885975162956421*^9, 3.8859751687928877`*^9}, {3.885975253564953*^9, 
   3.885975292171652*^9}, {3.8859753684038987`*^9, 3.8859753944654756`*^9}, {
   3.8859764080472107`*^9, 3.885976444462107*^9}, {3.8859766205505714`*^9, 
   3.885976701234559*^9}, {3.885977061431158*^9, 3.885977105613533*^9}, {
   3.8859775666625447`*^9, 3.8859775972455435`*^9}, {3.8859793109661627`*^9, 
   3.8859793451759176`*^9}, {3.8859793845178595`*^9, 
   3.8859794119426813`*^9}, {3.8859794524741387`*^9, 3.885979469919469*^9}, {
   3.8859796644128475`*^9, 3.8859797943053474`*^9}, {3.885979909660304*^9, 
   3.885979925707234*^9}, {3.885980058912956*^9, 3.8859800719340887`*^9}, {
   3.8859802956113253`*^9, 3.885980299515154*^9}, {3.8859803946280155`*^9, 
   3.8859804083447933`*^9}, {3.8859805548112154`*^9, 3.885980558763019*^9}, {
   3.8859806884189878`*^9, 3.8859807559686003`*^9}, {3.886061779883998*^9, 
   3.8860618911826696`*^9}, {3.886062270796764*^9, 3.8860623299442167`*^9}, {
   3.88606290416301*^9, 3.88606290438365*^9}, {3.886152279651626*^9, 
   3.8861523073398314`*^9}, {3.8861523706298904`*^9, 
   3.8861523714286704`*^9}, {3.888311253563958*^9, 3.8883112815379667`*^9}, {
   3.8895154757176466`*^9, 3.889515521326418*^9}, 3.889668778999714*^9, {
   3.8896725208785334`*^9, 3.889672555662263*^9}, {3.8896761687511916`*^9, 
   3.8896761875813046`*^9}, {3.8896762430656424`*^9, 3.8896763228575*^9}, {
   3.890203680281665*^9, 3.8902036879233007`*^9}, {3.890203721626855*^9, 
   3.8902037336503353`*^9}, {3.890203765562109*^9, 3.890203784550714*^9}, {
   3.890216653073305*^9, 3.89021672873991*^9}, {3.8902167682576685`*^9, 
   3.890216804044831*^9}, {3.89021744880861*^9, 3.890217482686234*^9}, {
   3.8902177558058324`*^9, 3.890217761492506*^9}, {3.8909816465407667`*^9, 
   3.890981653810565*^9}, {3.8909826260035453`*^9, 3.89098264917115*^9}, {
   3.890982718701262*^9, 3.890982720715917*^9}, {3.891426718226295*^9, 
   3.891426726438856*^9}, {3.8926185908487453`*^9, 3.892618596648994*^9}, {
   3.902310506985968*^9, 3.902310517162459*^9}, {3.9023110651639147`*^9, 
   3.90231107837062*^9}, {3.9023122609449267`*^9, 3.902312326613968*^9}, {
   3.902312741359663*^9, 3.902312815717987*^9}},
 CellLabel->
  "In[1774]:=",ExpressionUUID->"5cc1674a-6b09-4f41-a48c-1487561a3f0f"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[0.003666666666666667], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUV3c8le8bPtveq0hEQygjKqPeY0ZkpJIKSVIoUl+VUhRNkZGULRmlklmJ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         "]]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[0.003666666666666667], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUV3c81e8Xv8a1x51GSISyEyHRtSIlkRQZoVKkQUlllJWihBapNIiGaEhF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         "]]}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         PointSize[0.003666666666666667], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUV3c81e8Xt2f25l73XkQlJX0pI0dKJbIbJLQQUUZkVEhDFEUkEikpUtGw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         "]], 
        LineBox[{{1.5366350697876523`, -11.512925464970229`}, {
         1.5372418716328362`, -9.088053966153531}, {
         1.5379018002881693`, -9.654905309286283}, {
         1.539220557125797, -9.380316612766919}, {
         1.5397612141801684`, -11.512925464970229`}}], 
        LineBox[CompressedData["
1:eJwB0QIu/SFib1JlAgAAACwAAAACAAAAANCLiM6k+D9bqqIqngYnwCW7k58K
pvg//0Hl6CA9JsAJq5NwvKj4P4QdTGuyRSPAPr16zW2r+D8YLaHGcEMkwFP/
b7Yervg/cedNXjaiIcA3yT8Qz7D4P1RYRWaw5iLA29zKEX+z+D/rj8EStqoh
wJHR2J8utvg/Hz0L5wpgIcByZpC63bj4P8kyczZ8ICLAJ/vPRoy7+D9fdfNQ
IrokwH1RU3s6vvg/wRkWsc2KIsARD/Q86MD4P84pmq1X1yPAWaXYi5XD+D/v
MQQr+78kwARk8UxCxvg/Cp+ezanxJMChPtW27sj4P47Qp6RCDyTAVNFvrprL
+D/wNTajyhQkwMFA5zNGzvg/sFZITmTtI8AWtT0s8dD4P4za4WolDiPAJYXl
zZvT+D9Lh16AffolwAos3P1F1vg/Ch40CKAqJMBfgke879j4P7U+Ec0iuSLA
fHE77pjb+D9YSkCqa8YhwJHkBcpB3vg/8JZ8sM2zIsALrHEukuP4Pyuvw9Sg
TiLAISFenDnm+D8CRBGiUK0jwNstpbTg6Pg/l4tTRxtcIsAyKsuTLe74P2T+
EoHu7SHAjHUfl3jz+D9CmkmNC8giwAWOSH4d9vg/6hdY7FIEJMCsxab1wfj4
PxXDWcDvviLACr+C4mX7+D9BZ3bSWw0iwEFFvnoJ/vg/kYmRmaWgJMAfZ52j
rAD5P7cGXWs0ZyLA4tREXU8D+T80KE2lOUUiwK8s2afxBfk/AzEKoAQGI8CE
zLhokwj5PwaEycP5YSPAEvGY1TQL+T8pR8Q1lBokwF1s09PVDfk/E3nmuN33
JMCDlIxjdhD5P9jrXM+mqSXAAxE0ahYT+T/w+VcPoNMhwISuWx22Ffk/rTQg
eOPxIcCsjm5iVRj5PxOZJvuX/yTAU8CQOfQa+T+H8hIvyRokwPHtSBIBHPk/
W6qiKp4GJ8Cz6mSs
         "]], 
        LineBox[CompressedData["
1:eJxFkm0s1AEcxy/C2qwz53kZ//8dceTh5iHS/eYhTeyaPBRChDhtNyt6WLW5
RcYRi8Vu83QtdqQMma3y021K58hm14MwLcNoSaX7NbtLr3rx3efV581nXyZX
dirfjMPheO3uH/+wxQ4mhiBD3SlstTyIwxnutlMswZrB8qjFDIOqrHVRsQfB
crTZxsQQi7FBK1orL4Kc3Irkvr0seqdk2z4QEnzYHzPUL2exBJbW4RCBb7hx
dJ+cwabS+jNz/gQphu4jLuEsdm5zxWUiAu9BTYTGyKIktWrGJpggixdmmB1k
cMut2aAOJXjnXAQtUQJcrs8diAkn6NDyAvUSFlUtypX5CIJE0+qa/TCDGoe4
N2VAMD2yQeFnBWiqdonkRhGgf926T5UAo7+JErpiCDoXq3QGE4OL3NMz4uME
Gy1tv3OTPLAdpBb6OALpbJ512kcWdz77Tl1MIFhw1P+Yj+Cjx+MxH/OTBGEl
0Q2Tcj5qQ4zmLYkE4u/3FX7xLG7JVDV+yQS/qhul2fcYlNTIuzWpBJKcsT1B
kwwK7V685+UQONUoqowMg+bB40sPzxPor+hUjwoZ5PSoC8IKCHpE565ZZjPo
c3hVqS3c7R1cXl7Xx+JCfsmFzGKCzbQnXWm+njiXxw21uUTQWzHzVfnMExXr
rpntpQSudeS+GM9HnR3jEnCVQCewV6dPsFg7EpA8ep1gu3jDXZ7Cx5eOlSC5
SfBqfKI5opKPSw5Zn6RyAtWa29v6JBan04WXDbd3fZ0we/41g4Gx/c8r7hDE
FeWPRfJYPMG74dSmIHA7YDxmveCJ4g5nG5+7BEbVl4FepQDt5pZHnjYQuGut
NmtD+Cjj2O9ENhJoROPS1lt8DJb9zNQ2/f/bX8gGQMw=
         "]], 
        LineBox[{{1.5996897867035682`, -11.512925464970229`}, {
         1.600556598639724, -8.82986974440642}, {
         1.601176148054466, -9.10273694223152}, {
         1.60179531386538, -9.556386424340953}, {
         1.602414000507563, -10.095928126241427`}, {
         1.6042680546905144`, -9.040711131135236}, {
         1.6048852138422856`, -9.427549961150689}, {
         1.6054915641021539`, -11.512925464970229`}}], 
        LineBox[CompressedData["
1:eJwB0QEu/iFib1JlAgAAABwAAAACAAAAX4d2xSyw+T9bqqIqngYnwFQ/9WWp
svk/PFC+b3hUIsBU1dRwL7X5PxpZsWbQ2iPA5szeFbW3+T93rD7SFhEmwEb6
jzs6uvk/EHiUvTj3JMAqWKCJQ7/5P0rAcyn3/CHAnRyYmMfB+T/fcbdADucj
wL3wxihLxPk/mPR6eq4II8DsvBPI08v5P+p4NrsxiSHAP3NS9Fnd+T+RKTrG
WNwkwD7s9UzZ3/k/z4zstQZmJsDj8nkoWOL5P64kdqMYgSDAJyjIudbk+T+P
f39lLx4hwLxWmOdU5/k/yUBTcJs1I8DSu/oDze75PxmQD+Ad+yHAEgUMpUnx
+T9KDxvHUz4hwKihOePF8/k/WbTxmQAzIcC7gF6lQfb5P/U4NLl7DiPArTtj
NDj7+T8Y2eEN7JwhwNj5jiAtAPo/JyW0Cd+mIMDIJvEPpwL6P+3pDUFFeCHA
U2VFnSAF+j8fe0HvAnMhwBsGqsiZB/o/U4Z9hJuYIsDLvRh5Egr6P9g4viqV
OSDAQ7784IoM+j9Axv3aJv0gwCvUI4x6Efo/kPclfRAnIcCk/Y228RP6P4/T
00CB1xzAITLWmGgW+j9U3HJ2yVcfwOQd5eY=
         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {-6.487169751504421, -11.512925464970204`}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
         TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameTicks -> {{{{
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "4"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           
           TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           
           TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           
           TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           
           TemplateBox[{"10", "5"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000], -10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 3]], -10.41431317630212], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000], -10.126631103850338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000], -9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000, 3]], -9.721165995742174], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 7]], -9.567015315914915], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500], -9.433483923290392], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 9]], -9.315700887634009], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000], -8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 3]], -8.111728083308073], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500], -7.824046010856292], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000], -7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000, 3]], -7.418580902748128], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 7]], -7.264430222920869], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250], -7.1308988302963465`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 9]], -7.013115794639964], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000], 12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000], 12.611537753638338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000], 12.89921982609012], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000], 13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000], 13.304684934198283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000], 13.458835614025542`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000], 13.592367006650065`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000], 13.710150042306449`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000], -10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 3]], -10.41431317630212], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000], -10.126631103850338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000], -9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000, 3]], -9.721165995742174], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 7]], -9.567015315914915], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500], -9.433483923290392], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 9]], -9.315700887634009], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000], -8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 3]], -8.111728083308073], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500], -7.824046010856292], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000], -7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000, 3]], -7.418580902748128], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 7]], -7.264430222920869], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250], -7.1308988302963465`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 9]], -7.013115794639964], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000], 12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000], 12.611537753638338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000], 12.89921982609012], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000], 13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000], 13.304684934198283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000], 13.458835614025542`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000], 13.592367006650065`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000], 13.710150042306449`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}, {{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[1, 0.75, 0], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.647624, 0.37816, 0.614037], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.571589, 0.586483, 0.], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.915, 0.3325, 0.2125], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[
          0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
          AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
       "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
       Scaled[0.05], "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> 
       True, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-6.487169751504421, 
      1.630470845239991}, {-11.512925464970229`, 11.512925464970229`}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {0, 0}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], 
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0]}}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"31 m\"", "\"10 m\"", "\"1.5 m\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontSize -> 14, 
          GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.003666666666666667`", "]"}], 
                   ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.003666666666666667`", "]"}], 
                   ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.880722, 0.611041, 0.142051]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.003666666666666667`", "]"}], 
                   ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.560181, 0.691569, 0.194885]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"True", ",", "True", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.8527879438310833`*^9, 3.852787964921023*^9}, {
   3.8527880302138367`*^9, 3.8527880537745132`*^9}, 3.852788084697062*^9, {
   3.8527881270170593`*^9, 3.852788224333301*^9}, 3.85278831785238*^9, 
   3.852788361683811*^9, {3.852795206034478*^9, 3.852795268644823*^9}, {
   3.852795796660235*^9, 3.852795803347172*^9}, 3.852862499690114*^9, 
   3.853381367103548*^9, 3.853381477275778*^9, 3.8534022418114157`*^9, 
   3.853402534499599*^9, {3.853405270422613*^9, 3.853405324836055*^9}, 
   3.853405407395211*^9, {3.8534097505906153`*^9, 3.8534097703076878`*^9}, 
   3.853410187279647*^9, 3.8534102457215548`*^9, {3.853410571397106*^9, 
   3.853410595830978*^9}, 3.853469096590513*^9, 3.853469303037784*^9, 
   3.853496283640119*^9, 3.8534996296665163`*^9, 3.853817848440113*^9, 
   3.8538182517655993`*^9, 3.853824687596098*^9, 3.85382487471694*^9, 
   3.8538330798017387`*^9, 3.853836456463883*^9, {3.853836638285132*^9, 
   3.853836690462969*^9}, 3.853838543040962*^9, 3.854072558224156*^9, 
   3.854091678576386*^9, 3.8540984652252827`*^9, 3.8544207625736847`*^9, 
   3.854421344558304*^9, {3.8544214059054337`*^9, 3.854421491046699*^9}, 
   3.854423662477191*^9, 3.8601208220618477`*^9, 3.860120994483048*^9, 
   3.86012125099901*^9, 3.860140222318944*^9, 3.8601412086662254`*^9, 
   3.861763743975759*^9, 3.86176383617095*^9, {3.8617640582820826`*^9, 
   3.861764074747286*^9}, 3.8617641740186996`*^9, 3.861764274902935*^9, {
   3.8617643353175488`*^9, 3.861764372253722*^9}, {3.861764623510527*^9, 
   3.8617646348513403`*^9}, 3.8617647132308836`*^9, {3.861767375375707*^9, 
   3.861767457590822*^9}, 3.861941029316691*^9, 3.861950322744031*^9, 
   3.8636862718685603`*^9, 3.8636872310576773`*^9, 3.885975309403617*^9, {
   3.885975375253332*^9, 3.885975398991347*^9}, 3.885976450290474*^9, {
   3.8859766273930984`*^9, 3.885976705321181*^9}, {3.885977079657692*^9, 
   3.8859771107489624`*^9}, 3.885977602788784*^9, {3.885979327503832*^9, 
   3.885979350000666*^9}, {3.8859793893365097`*^9, 3.8859794164248023`*^9}, {
   3.885979462547427*^9, 3.8859794743961115`*^9}, {3.8859797044283705`*^9, 
   3.8859797993350043`*^9}, {3.885979917813003*^9, 3.885979931062524*^9}, {
   3.8859800636906133`*^9, 3.8859800779593983`*^9}, 3.885980312698554*^9, {
   3.8859804016551037`*^9, 3.8859804126591787`*^9}, 3.8859805640552745`*^9, {
   3.885980715872667*^9, 3.8859807602126627`*^9}, {3.8860618090326586`*^9, 
   3.886061895699357*^9}, {3.8860622756094923`*^9, 3.8860623347401624`*^9}, 
   3.8860629092400513`*^9, {3.886152285047185*^9, 3.8861523259663725`*^9}, 
   3.8861523762490544`*^9, 3.888310979206479*^9, {3.888311255213608*^9, 
   3.888311282957345*^9}, 3.8890022856520777`*^9, 3.889060337400128*^9, 
   3.889064570327097*^9, 3.8890819151049967`*^9, 3.889082751667604*^9, 
   3.889084481475959*^9, 3.889504256968684*^9, 3.8895154808895187`*^9, 
   3.8895155265896363`*^9, {3.8896687737857976`*^9, 3.8896687838826714`*^9}, 
   3.8896725629108257`*^9, {3.8896761751473627`*^9, 3.889676192632434*^9}, 
   3.889676249961451*^9, {3.8896763044816694`*^9, 3.8896763296834364`*^9}, {
   3.890203672586771*^9, 3.8902037015966415`*^9}, 3.8902037493461847`*^9, 
   3.8902037965747986`*^9, {3.890216658915124*^9, 3.8902167333765697`*^9}, {
   3.890216774140562*^9, 3.890216809078682*^9}, {3.8902174567679343`*^9, 
   3.8902174874612885`*^9}, 3.890217766852687*^9, 3.8909816129922285`*^9, 
   3.890981659451852*^9, {3.890982631522698*^9, 3.890982655851638*^9}, {
   3.890982726501892*^9, 3.8909827519660463`*^9}, 3.891416093072353*^9, 
   3.8914267640437527`*^9, 3.892618602412215*^9, 3.8926186799276247`*^9, 
   3.892628523990633*^9, {3.9023105117654276`*^9, 3.902310525194955*^9}, 
   3.90231098194772*^9, {3.9023110756606584`*^9, 3.9023110843092566`*^9}, 
   3.902312275320979*^9, {3.902312310191203*^9, 3.9023123323759384`*^9}, {
   3.9023127524218903`*^9, 3.9023128209711933`*^9}},
 CellLabel->
  "Out[1775]=",ExpressionUUID->"d4810b03-1cb2-4058-bcac-b8a85082269a"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2022-08_\
new_data\\\\Analysis\\\\Full form factor fit\\\\LH-ESRF-C16 - volume (not \
corrupted)\\\\DataSubtracted.pdf\"\>"], "Output",
 CellChangeTimes->{{3.8527879438310833`*^9, 3.852787964921023*^9}, {
   3.8527880302138367`*^9, 3.8527880537745132`*^9}, 3.852788084697062*^9, {
   3.8527881270170593`*^9, 3.852788224333301*^9}, 3.85278831785238*^9, 
   3.852788361683811*^9, {3.852795206034478*^9, 3.852795268644823*^9}, {
   3.852795796660235*^9, 3.852795803347172*^9}, 3.852862499690114*^9, 
   3.853381367103548*^9, 3.853381477275778*^9, 3.8534022418114157`*^9, 
   3.853402534499599*^9, {3.853405270422613*^9, 3.853405324836055*^9}, 
   3.853405407395211*^9, {3.8534097505906153`*^9, 3.8534097703076878`*^9}, 
   3.853410187279647*^9, 3.8534102457215548`*^9, {3.853410571397106*^9, 
   3.853410595830978*^9}, 3.853469096590513*^9, 3.853469303037784*^9, 
   3.853496283640119*^9, 3.8534996296665163`*^9, 3.853817848440113*^9, 
   3.8538182517655993`*^9, 3.853824687596098*^9, 3.85382487471694*^9, 
   3.8538330798017387`*^9, 3.853836456463883*^9, {3.853836638285132*^9, 
   3.853836690462969*^9}, 3.853838543040962*^9, 3.854072558224156*^9, 
   3.854091678576386*^9, 3.8540984652252827`*^9, 3.8544207625736847`*^9, 
   3.854421344558304*^9, {3.8544214059054337`*^9, 3.854421491046699*^9}, 
   3.854423662477191*^9, 3.8601208220618477`*^9, 3.860120994483048*^9, 
   3.86012125099901*^9, 3.860140222318944*^9, 3.8601412086662254`*^9, 
   3.861763743975759*^9, 3.86176383617095*^9, {3.8617640582820826`*^9, 
   3.861764074747286*^9}, 3.8617641740186996`*^9, 3.861764274902935*^9, {
   3.8617643353175488`*^9, 3.861764372253722*^9}, {3.861764623510527*^9, 
   3.8617646348513403`*^9}, 3.8617647132308836`*^9, {3.861767375375707*^9, 
   3.861767457590822*^9}, 3.861941029316691*^9, 3.861950322744031*^9, 
   3.8636862718685603`*^9, 3.8636872310576773`*^9, 3.885975309403617*^9, {
   3.885975375253332*^9, 3.885975398991347*^9}, 3.885976450290474*^9, {
   3.8859766273930984`*^9, 3.885976705321181*^9}, {3.885977079657692*^9, 
   3.8859771107489624`*^9}, 3.885977602788784*^9, {3.885979327503832*^9, 
   3.885979350000666*^9}, {3.8859793893365097`*^9, 3.8859794164248023`*^9}, {
   3.885979462547427*^9, 3.8859794743961115`*^9}, {3.8859797044283705`*^9, 
   3.8859797993350043`*^9}, {3.885979917813003*^9, 3.885979931062524*^9}, {
   3.8859800636906133`*^9, 3.8859800779593983`*^9}, 3.885980312698554*^9, {
   3.8859804016551037`*^9, 3.8859804126591787`*^9}, 3.8859805640552745`*^9, {
   3.885980715872667*^9, 3.8859807602126627`*^9}, {3.8860618090326586`*^9, 
   3.886061895699357*^9}, {3.8860622756094923`*^9, 3.8860623347401624`*^9}, 
   3.8860629092400513`*^9, {3.886152285047185*^9, 3.8861523259663725`*^9}, 
   3.8861523762490544`*^9, 3.888310979206479*^9, {3.888311255213608*^9, 
   3.888311282957345*^9}, 3.8890022856520777`*^9, 3.889060337400128*^9, 
   3.889064570327097*^9, 3.8890819151049967`*^9, 3.889082751667604*^9, 
   3.889084481475959*^9, 3.889504256968684*^9, 3.8895154808895187`*^9, 
   3.8895155265896363`*^9, {3.8896687737857976`*^9, 3.8896687838826714`*^9}, 
   3.8896725629108257`*^9, {3.8896761751473627`*^9, 3.889676192632434*^9}, 
   3.889676249961451*^9, {3.8896763044816694`*^9, 3.8896763296834364`*^9}, {
   3.890203672586771*^9, 3.8902037015966415`*^9}, 3.8902037493461847`*^9, 
   3.8902037965747986`*^9, {3.890216658915124*^9, 3.8902167333765697`*^9}, {
   3.890216774140562*^9, 3.890216809078682*^9}, {3.8902174567679343`*^9, 
   3.8902174874612885`*^9}, 3.890217766852687*^9, 3.8909816129922285`*^9, 
   3.890981659451852*^9, {3.890982631522698*^9, 3.890982655851638*^9}, {
   3.890982726501892*^9, 3.8909827519660463`*^9}, 3.891416093072353*^9, 
   3.8914267640437527`*^9, 3.892618602412215*^9, 3.8926186799276247`*^9, 
   3.892628523990633*^9, {3.9023105117654276`*^9, 3.902310525194955*^9}, 
   3.90231098194772*^9, {3.9023110756606584`*^9, 3.9023110843092566`*^9}, 
   3.902312275320979*^9, {3.902312310191203*^9, 3.9023123323759384`*^9}, {
   3.9023127524218903`*^9, 3.9023128228091526`*^9}},
 CellLabel->
  "Out[1776]=",ExpressionUUID->"6a874242-ba56-4a25-81f5-3f00879796a8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Merge", " ", 
    RowBox[{"(", "relevant", ")"}], " ", "patterns"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Usually", " ", "we", " ", "only", " ", "merge", " ", "pattern", " ", "2",
      " ", "and", " ", "3"}], ",", " ", 
    RowBox[{
    "but", " ", "sometimes", " ", "we", " ", "also", " ", "use", " ", "1", 
     " ", "when", " ", "2", " ", "contains", " ", "a", " ", "weird", " ", 
     "kink", " ", "or", " ", "noise", " ", "etc"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"only", " ", "pattern", " ", "2", " ", "and", " ", "3"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"datamerged", "=", 
     RowBox[{"mergeData", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.1"}], "&"}]}], "]"}], ",",
        " ", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"default", ":", " ", 
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.5"}]}], "&"}], " ", 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "3", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0.06", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "2"}], "&"}]}], "]"}]}], " ", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"default", ":", " ", 
         RowBox[{"0.2", "<", 
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "<", "2"}]}], "&"}], " ", "*)"}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"only", " ", "pattern", " ", "1", " ", "and", " ", "3"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"datamerged", "=", 
     RowBox[{"mergeData", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.1"}], "&"}]}], "]"}], ",",
        " ", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"default", ":", " ", 
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.5"}]}], "&"}], " ", 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "3", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0.06", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "2"}], "&"}]}], "]"}]}], " ", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"default", ":", " ", 
         RowBox[{"0.2", "<", 
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "<", "2"}]}], "&"}], " ", "*)"}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Sequential", " ", "merging", " ", "of", " ", "first", " ", "pattern", 
     " ", "1"}], " ", "+", " ", 
    RowBox[{"2", " ", "and", " ", "then", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "2"}], ")"}]}], " ", "+", " ", "3"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"datamerged1", "=", 
     RowBox[{"mergeData", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0.006", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.2"}], "&"}]}], "]"}], ",", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"default", ":", 
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.5"}]}], "&"}], "*)"}], 
       " ", 
       RowBox[{"(*", " ", 
        RowBox[{"0.005", "<", 
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "<", "0.2"}], " ", "*)"}], " ", 
       RowBox[{"(*", " ", 
        RowBox[{"0.02", "<", 
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "<", "0.2"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0.1", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.5"}], "&"}]}], "]"}]}], 
      " ", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"default", ":", 
         RowBox[{"0.2", "<", 
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "<", "2"}]}], "&"}], "*)"}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"datamerged", "=", 
     RowBox[{"mergeData", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Select", "[", 
        RowBox[{"datamerged1", ",", 
         RowBox[{
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.3"}], "&"}]}], "]"}], ",", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"default", ":", 
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.5"}]}], "&"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "3", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0.05", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.4"}], "&"}]}], "]"}]}], 
      " ", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"default", ":", 
         RowBox[{"0.2", "<", 
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "<", "2"}]}], "&"}], "*)"}], " ", 
      RowBox[{"(*", " ", 
       RowBox[{"0.05", "<", 
        RowBox[{"#", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "<", "1"}], " ", "*)"}], " ", 
      RowBox[{"(*", " ", 
       RowBox[{"0.05", "<", 
        RowBox[{"#", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "<", "0.7"}], " ", "*)"}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
    RowBox[{"datamerged1", ",", "\[IndentingNewLine]", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameTicks", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
          RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Automatic", ",", 
          RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",", 
     " ", 
     RowBox[{"(*", " ", 
      RowBox[{
      "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
       " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
       "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"LabelStyle", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
       "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameLabel", " ", "->", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
         "\"\<\!\(\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
       "}"}]}]}], "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"plotDataMerged", " ", "=", " ", 
    RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
     RowBox[{"datamerged", ",", "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
        " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
        "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}]}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<DataMerged.pdf\>\""}], "}"}], "]"}], ",", "plotDataMerged"}], 
    " ", "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Bin", " ", "data"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"datamergedbinned", "=", 
     RowBox[{"binData", "[", 
      RowBox[{"datamerged", ",", "0.05"}], "]"}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"default", ":", " ", "0.05"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"plotDataBinned", " ", "=", " ", 
    RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
     RowBox[{"datamergedbinned", ",", "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", "False"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
        " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
        "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}]}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<DataMergedBinned.pdf\>\""}], "}"}], "]"}], ",", 
     "plotDataBinned"}], " ", "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Export", " ", "merged", " ", "and", " ", "binned", " ", "data", " ", 
     RowBox[{"(", 
      RowBox[{
      "for", " ", "plotting", " ", "in", " ", "Python", " ", "or", " ", 
       "other", " ", "software"}], ")"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"exportlist", " ", "=", " ", 
     RowBox[{"exportData", "[", "datamergedbinned", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", "\[IndentingNewLine]", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"FileBaseName", "[", 
          RowBox[{"NotebookFileName", "[", "]"}], "]"}], "<>", 
         "\"\< SAXS data merged and binned.csv\>\""}]}], 
       "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", "]"}], ",", 
     "\[IndentingNewLine]", "exportlist"}], "\[IndentingNewLine]", 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.854423668689094*^9, 3.854423681960602*^9}, {
   3.8601210812169123`*^9, 3.8601211773702602`*^9}, {3.860121220142*^9, 
   3.860121220876803*^9}, {3.860121492525386*^9, 3.8601215079101877`*^9}, {
   3.860121718604267*^9, 3.8601217659879427`*^9}, {3.860121814486486*^9, 
   3.860121940090294*^9}, {3.860121990307417*^9, 3.860122029773138*^9}, {
   3.86012227550008*^9, 3.860122412026474*^9}, {3.860123590194846*^9, 
   3.8601236144362907`*^9}, 3.8601236508219957`*^9, {3.860139958454444*^9, 
   3.8601400142502003`*^9}, {3.8601409041122975`*^9, 
   3.8601409737863803`*^9}, {3.860141247131112*^9, 3.8601412486662936`*^9}, 
   3.860141363728487*^9, {3.861764464753133*^9, 3.8617644999883156`*^9}, {
   3.8617650690038815`*^9, 3.861765107161731*^9}, {3.8617654080879517`*^9, 
   3.8617654464808097`*^9}, {3.8617667857822647`*^9, 3.861766817572381*^9}, {
   3.861767478263466*^9, 3.8617674824174633`*^9}, {3.8617675156782837`*^9, 
   3.8617675385223627`*^9}, {3.861767600750394*^9, 3.8617678801582737`*^9}, {
   3.861768004639906*^9, 3.861768004842128*^9}, {3.8617680471976347`*^9, 
   3.8617680542883253`*^9}, 3.8617682512241673`*^9, {3.8619408859545107`*^9, 
   3.8619408879723635`*^9}, 3.8619500601432023`*^9, {3.8859755937637935`*^9, 
   3.8859756289602833`*^9}, {3.8859767824682684`*^9, 
   3.8859768072202587`*^9}, {3.885976912247283*^9, 3.885976915489427*^9}, {
   3.885977184321333*^9, 3.8859771875417037`*^9}, {3.8859772431391516`*^9, 
   3.8859772459190493`*^9}, {3.8859776946505795`*^9, 3.885977697414628*^9}, {
   3.885977754450777*^9, 3.8859777568929634`*^9}, {3.8859804425147095`*^9, 
   3.8859804438235583`*^9}, 3.8859804753994827`*^9, {3.8859807731997614`*^9, 
   3.885980782688805*^9}, 3.8860629984459877`*^9, {3.886063060466019*^9, 
   3.8860631273919067`*^9}, {3.886071125028043*^9, 3.8860711896934166`*^9}, {
   3.8860714254613867`*^9, 3.8860714550837*^9}, {3.8895154616447597`*^9, 
   3.8895154658794193`*^9}, {3.8896724114246473`*^9, 3.889672412507053*^9}, {
   3.889672471225835*^9, 3.8896725071452694`*^9}, {3.889674589350315*^9, 
   3.889674633174043*^9}, {3.889674670910601*^9, 3.889674765787591*^9}, {
   3.8896748131059356`*^9, 3.889674848516157*^9}, {3.8896748918371353`*^9, 
   3.8896749698660383`*^9}, {3.8896759808235216`*^9, 
   3.8896760211101522`*^9}, {3.8896760618397036`*^9, 3.889676134804789*^9}, {
   3.8896766120107994`*^9, 3.8896766124494815`*^9}, {3.889676755304323*^9, 
   3.889676755581999*^9}, {3.8902038545244083`*^9, 3.890203901273981*^9}, {
   3.890205930477414*^9, 3.8902059314228735`*^9}, {3.8902102550185256`*^9, 
   3.890210255342898*^9}, 3.8902167482021494`*^9, {3.8902168284956217`*^9, 
   3.89021682871568*^9}, {3.890216868216955*^9, 3.8902168763206763`*^9}, {
   3.8902172079856234`*^9, 3.8902172082346754`*^9}, {3.890981726002406*^9, 
   3.890981786213588*^9}, {3.8909822356137176`*^9, 3.8909822357713594`*^9}, {
   3.891426796114186*^9, 3.8914267996467695`*^9}, {3.8926189112287703`*^9, 
   3.8926189114608297`*^9}, {3.9023113594801064`*^9, 
   3.9023113598786087`*^9}, {3.902312371637211*^9, 3.902312372020201*^9}},
 CellLabel->
  "In[1720]:=",ExpressionUUID->"5b3c3b75-f6f9-43b4-ae93-bf843c1633be"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.004583333333333334], 
     AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJwUV3k8lN8Xnn3GjLFLkdCiiBBapN6xhqyhUpElFMqaSgklpD0qoVCKikK2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      "]]}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-5.2947168077195625`, -6.259176232216071},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) \
[\\!\\(\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], 
      TraditionalForm], None}},
  FrameTicks->FrontEndValueCache[{{{{-6.907755278982137, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm]}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm]}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm]}, {0, 
        FormBox[
         TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {2.302585092994046, 
        FormBox[
         TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {4.605170185988092, 
        FormBox[
         TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {6.907755278982137, 
        FormBox[
         TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.407945608651872, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.9162907318741551, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.3566749439387324, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.22314355131420976`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.10536051565782635`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.006367567650246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.294049640102028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.699514748210191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.85366542803745, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.987196820661973, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.104979856318357, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}}, {{-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.407945608651872, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.9162907318741551, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.3566749439387324, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.22314355131420976`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.10536051565782635`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.006367567650246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.294049640102028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.699514748210191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.85366542803745, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.987196820661973, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.104979856318357, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}}}, {
      Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
       15.954589770191003`, RotateLabel -> 0], {{-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.407945608651872, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.9162907318741551, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.3566749439387324, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.22314355131420976`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.10536051565782635`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}}}}, {{{{-6.907755278982137, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm]}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm]}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm]}, {0, 
        FormBox[
         TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {2.302585092994046, 
        FormBox[
         TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {4.605170185988092, 
        FormBox[
         TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {6.907755278982137, 
        FormBox[
         TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.407945608651872, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.9162907318741551, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.3566749439387324, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.22314355131420976`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.10536051565782635`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.006367567650246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.294049640102028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.699514748210191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.85366542803745, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.987196820661973, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.104979856318357, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}}, {{-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.407945608651872, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.9162907318741551, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.3566749439387324, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.22314355131420976`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.10536051565782635`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.006367567650246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.294049640102028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.699514748210191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.85366542803745, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.987196820661973, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.104979856318357, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}}}, {{{-5.298317366548036, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.005\"", ShowStringCharacters -> False], 
           0.005`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-4.605170185988091, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.010\"", ShowStringCharacters -> False], 
           0.01`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-2.995732273553991, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.050\"", ShowStringCharacters -> False], 
           0.05`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.100\"", ShowStringCharacters -> False], 
           0.1`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-0.6931471805599453, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.500\"", ShowStringCharacters -> False], 
           0.5`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.4079456086518722`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {0., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}}, {{-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.407945608651872, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.9162907318741551, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.3566749439387324, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.22314355131420976`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.10536051565782635`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}}}}],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  LabelStyle->{FontSize -> 14, 
    GrayLevel[0]},
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{-5.2947168077195625`, -0.6940203524770587}, \
{-6.259176232216071, 4.123646251832177}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], 
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0]}]], "Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.891426801668441*^9, 
   3.8926186413176928`*^9, 3.8926186824334993`*^9, 3.8926189121910763`*^9, 
   3.8926285278640122`*^9, 3.902311008206068*^9, 3.902311104132188*^9, 
   3.902311361239811*^9, {3.9023123510880857`*^9, 3.90231237279708*^9}},
 CellLabel->
  "Out[1722]=",ExpressionUUID->"407c6c8b-2a57-47f6-851e-07e8735351f5"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.007333333333333334], 
     AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJwVV3c41u0Xt589kV5F2oNslaj7S8jKVklE8iIzSZlR2nYkJKNBvZStSN+T
ValIkewRkfl47NnP76/7Otc553Pu8zn3dZ9zNp72NHPk4+HhyePl4fn/2bBR
bL+vpwjcj7m8ISWYiemciDWWPioCsZd2zceRmJgWYSY48IAITG3edMp4KxNr
Hl90Ob1VBOKBiAe0MLCOYXPVHzQReH8ufcdDFgM7rq10o2FGGLRCLucZyTAw
hQR3J6NuYTDZe9A/ZYWObTl8RPNwrTB4a40ldk3RsYU3z1uLC4XhzbekMqFL
dMwsZp35/VRhqKys8XPcSse6VTfTBm4LQ2LJlP6UKB0rt0nLfegrDBbBDy68
eEjDGm9oKpadFoafZz7Gc6/TsEEpavE+Y2GQWHvn3GNBGrap1CxZWF0Ydklc
cJXsoWJHyyN9dHeuxiN3FOl0UTH+WN2l72uEwcpL5pwpd1Wf5yJXICAM081a
k51qVOy6vo/ELy4bOju2SBL1Vu3Jmfz2PWyYKNfPSFmiYM9r+jV3fWWD/QMV
qbx+Cnabx9ZGHWeD8klb5dt+FMzZJ3c07gUbinE7eGJFwRgyb3GFh2yYfHNa
6McsGct2ufSUGckG90yFlgNzZOybgWK8XDAbXH1u8ZspUTDWed2EcA82yLUY
afobUjCj6hd1W0+xQVWD1XQwgoz1piZ6zxuzYbQ/IbrdioztPKXxQVCDDZ43
s1XENpIxRZnPqnqKbEhoTzRq+ELClt14FSo2s+HMsTPLu6JImFzNTVlPUTb0
K8rL5emQMNX7AxVGBDaUVd5furxMxNr7H0WcmmfB3pUQqbOlRKxZmrsnbZgF
gaqxHT0EEvZuds01RicLTudfTXlVQ8QMdBz2Z39lgY+J773xY0Rsl0/jrguV
LCg48vTsuYNE7FJil4pLMQt0EtI+Y5uJWP+nDu0bz1gQrOAy0/SCgMVFhhrX
PWDBLb3wqpnHBKzESc/wQDQLph5u9Oa1I2CdLzSNvl9lgWmchcQ9PgL2O3Sz
fdRFFjw/X3+Cn0TARqLVHnq5suCBQQZ+hCOELQhPbvM9xYJQV5cc2QIh7MT4
2S2p5iyI1dq04zQIYXFCnhVDh1lws7701z1nIWxt9qLGcXUWaN+v5ilsFMKW
/KLbf8uzIMhWPDI2TAibS239Eb+VBSuXmZbac4KYd9t/AWfEWdBSllLV6S+E
/ThfvM6MwQLLsu/XdxkKYaqthjRbARZ8dqRnL38WxMZYtZk35plg8vGd6XyW
INbLV2dRN8YE07I96o0BgthSb+UFhT4mJIqEAydYEJOiql/IbWFCzbGQpw32
gtg1aYsK/XomWEakvezeIIj9/vfm179VTFC8ZahiOi+AeXl5CNeXMiFskj+S
XCWAGbFn6a9ymfAo9darGQ8B7F5g3MHSp0ww27Nh3tFWAHOsjdva9IAJVv11
OGYogJk+atUn3mWC9+0cby0xAYzrV7rP/BYTDLpjpb3n+LHtbi2BRZeZoDAi
9rdNWQBrz6FlyfoygfNU4cfYMD/m6YwZvXVjgn6jorxsBj9msWAidMaBCXF+
Fm4JdvzY8UfXTm84wQSns3W3dJ35sdfNpnSOCROW9Z69Etde9b9ult50mAkF
vnqqzml8mI6dann9QSYs2gSZyTP5MZcSeaFOFSY8xt1Fldn8WEt89Sae3UwI
fCK+f+9VPiyv6luZyhYmtBF2Nln68GEjJW6BweuY4D8rRgl9yodRzOtYrWwm
5Mz8Dn09yofVBuhI65KZQNb6tM5wNx92z2ub/wfe1XwfdDQVWfNhyvn2DkVc
BijIFHgmLPFisQxh+nIPA6QEZMs9PHkxJD5l4dTAAFlTxyLfNF6sJxxVTQID
7gSXDH3N58VCr5+oTM9lQIqunUjgCC9WFna21iuNAbumtjv8Y8CLCXq8t7CL
ZsAzL2/9ys282Dax3m7PEAYceyAmkLWbFwuqkuY89GLArQ/vTidK8WJpyStC
o3YMOKw/Kp0SwYNpLFzPtjJlgGj3yQGiKQ8mlJVztk+DAesebbuoOsmDBbfw
1YUrMkCSaxu/5gcP9m3hmaPZZgbE7ncc8Xr6Fzmp6lQqizDA4l+nzBvn/6Kj
ao0eSoIM8B7+k3FZgwczub+0xmiGDtVbToyyDXiww/l6umEDdKiXrjxpmPYX
TQ9lpTT9pMMX1tcWh3srqHm3fKFGLR2OzL9KaKD9RfKmdOkPZXT4I3fio4j0
X2TLH/jIOYcOW/ie2VQMLaOsgzmwKZUOyaPB2oe2/UUjByq3z0TTIb6l+ruf
1QpqG3l7ufcKHShv3C5VriyjV3Xnzw340MFJvCjA3HgZvT8akCngRIfvMRyT
eedlVJ+zo07Vig5aJTfVOJHLqMPgws3rBnSonOkaTHy8jJSjtz0YOkAHIZTa
bqWyjL52n3zpKL9qPzRpEDa+hOL6u3xmN9FhE99W1LywhJyezaelitJhzNNP
Re3iEmIluv2xIdJhkumkkbdtCXk0uggqLtLgnmCThe2hRdRWdyNn3RgNbJVj
XJWeL6Dvaq+TxXtoMJi5I3Rd1CL6qqV1R7aRBvwiv5uKuxcQLli679h7Gojo
1/I7nFxAtkfG7ONKaaCZ3lk4lLOAvqm8LuvPoUH87yK7PtEFpCjSIm6QToN1
fCU2YXLzSEjWZ09VHA1CCDVXOPfnUX7iugaTmzSouiYUd1p6AYneDHrBCaDB
PiEnsnXjPFo6a3v3kScN3mZUH9KKmke/jGO1XRxo8Gxj9EKIwjza4z5zR+MY
DfKSo0qSgueQXvdZWRkDGuRDdGakyzzSS/o8vQPRQC+cHOtqMo9C/cf/26tE
A+nivsBm9TnkEnd/3fHtNCAbPr3dtmsOjadeYt5eR4O2ivq7IVGzyNUh/8gX
Bg2uhAetmyfNoT0TBQUbBWhws+Y60lCZQ2SyMeHGHBVOf2reI8ozh176vhBb
HqFCpocUTejRLCqVrC+82kMF5UTjf6dfzqAPVgEvxX9QQS3M6ZfxrVk0bq/T
8q6WCrrJkbpHrWaR7u8bAn74qn/yxaYHwbPozptjAlghFaSODrpjJ2ZQXu6t
7DXPqGDnZt+jjmbQy3PPGpZSqFDbThF+kTiDNJNmdLmxVDgXu7ue4jWN+Jvs
BmduUGH6Xco3yQPT6I1uSRA5iApfmC/ieo7OoO1b+iZkvKmADxkaFJ2ZRspo
TtjWiQqyobI2/henkdt48JuUk1TYrFpNW7g5jUw/plcNm1Ih6rAUn6/MDLpx
dKuQ7mEqxMpecDPPnkJlPY7W+epUWDcc9nHTyBRKP2aRukuRCliDW+o3vynk
oH4+J3c7FSY7P884vZtC7YXf7bUkqJCoKXH3W+kUoj1iJ/azqSBU/v1ntdIU
UmqylI8jruY/nKVkWTqJhnT0BE1WKLDzSMv+6UuTyON4z+jaKQp0ze+t+DLM
RQl045axPxToE5To50pMIq/AgIcNXRSQDFDUf1Y5iVpUWBLvmijA3pqWjw1N
oqiDyirlnyhw7EsL7b79JKLlXH5f/Y4C1LPq8q0ULlJz4C1vLaGAg1a9YYch
Fyn7HWlezKHAy23e3v/e5KKSRk2pnY8p0FtwtsIUuEhfS+fs6aTVeAVR2lA4
gSxfb7mfGU0BxfcNHcIsLnKWFY2Yu06B3YkiU6VULlLPKpaxDKLA9fgQwvrh
CfRMk25dfp4CG/3DL1+I4SANvWtL8mcpsLc9ISTwPAftsx6YfmlHgTkT8h55
Hi4yTrKT2X+MAgplO4INNk4gl76Aa/VHKDBx5egxF4cJFCG2ccBTiwI1ac+3
fd/HQXx2d/euU6OAZ/2uUC2TVfxoT5sGBQoY7d0je8+Ug0KvPEexOyhwfN5W
NW47B4Vdjaq22UCBxztdlj7LjKNbNW9/KK2hgMnVwiRV+XG03CNtLUKjwPBH
C4oa3zhqsFiv9pefAoaP/my4YstBm0S2nZpaIEOMHFPZ+tYYom2UzZ2cIEPW
ALZBunwUuW5zElseJEOQBuIpKBlFhyRNgpndZGibeJxBXxhF71fy63Y3k+Hk
mYkVQu4ISvN4xLWoI4NNZ12piNsYyhbTr7lWTYaeZ41/BE1G0JV4MFkdlqHt
cnhLc8Qw8qHmeAgUkqGcrFrmVDeCTgceoJj9R4b9diSdku9D6PqVX6xnGWRQ
J4y48OcPI46KuQcpiQw6DQ0bfzWPIDb5CvV8DBkKf9QkGU6MIoOSJz/7b5JB
1vLg5BvRYbR/pxJuH0IGntg2SR/6EKrx7sj+fZEM3N203UVr/6DU93GRPp5k
oLUlu8vtGkRyAddMKU5k+Oy6twEsVu0FxH49tyXDJqUfihyjP2iAOCxvfpQM
sODzMGhgEKU4te8QMCLDr5o25zD1AZRlvPKqXJsMded88gNnB9D5o8n1lw+Q
4bfE450h/YOoKE7ZWl+FDCWjWoLDR/+gmPch+hK7yWAkxX5Oax9ACr6u4XNb
Vutx4pLXU+lVvHUizPb1ZFCycVobmTOARC2/VL0XIcPd6RPfR/R/oz7h9Ull
VDLkX7t754LCIFrTWHy5RIAMGzhY1+utA8j3R5hj2RIJ1pCvghv7N3pim6L2
fooEVqds5QWnfiPtKyH9rSMkiNHkkTSUG0S6X9TdZ/pI0Hnh9Il9B/tRumBG
8T8dJAjLpL48t9SHWuVD8rWaSMBY+GepOL8fba/6bnrxCwk4asUdZla/UPFs
1bW8ahJUX+38ueFiL9KQyEST5STopvvFXLnYj+rmZ73Ui0mgrhWmYDPWh+I2
naJEvCCBrrDzocXBX2jwZA5P/1MSjN0Zyu2I6UVbeds1tVJJIPrf22fNxb9Q
iB216nkCCWYyPq/s4vai4t03fNdGr8r0+dpX2d0oZLDMMOImCRpaeN/q3O1F
VQaYKimUBCY+B34eTu5DXm/rZcP9SOCdyHngGN6Dxmv0pdZ4k2Ao0utWtPYv
tDu0mCfzLAkyysSv+hv9QuJi6pUHHUjwx2i6b31RL0pU22HdYU2CI69CL22n
/kKtmUNlVyxI0PwlNIBj1IsEk0VbZI+s5mfWLpHv1YsUT9o87dEmQc/BphXG
/S50/22CWPLBVT521pb5l3ShhcwyKeu9JBDzPsWXUNuNtid2F22UJ4HXvrV5
Y4wedGFLBj62gwQXCLuYp6a60X25JL2KjSTwiXj38odXJ3L7eF/9gTgJfnFE
DFrftaBhG6WIQOFV/kQkh1FjO/Iol5B3oK7ez/XQqZ6v7Ugub6e4iSAJci04
k1bQjlJidLBDK0Rw3HSm5PWVNnSzMyRBfZYIK5bl5s/vtyNqC6+oOocInrct
paIiOpHmBsYLjT9EcH26wFw/0oHu65GPH+klQgXf7LTGq1b0+5YX8VQbETac
KHh1YFszEjZsLfRtJMK6PjlHZUI7svu5YBb3hQhHNtSpUxktSHs29WdJDRF4
fQryvQ7+RF/v5an14ET4MlpTJH+yBYWfU/BmvibC4xvGWqPFP1Fv8X5v7Xwi
7Kf0K5vrNKOhQl7FkP+IMLVD5Yqc2Q/0/Or3THhMhNBzcO2fip+oNE+0Vugh
ET59ZhVKBf5EGFc7yiyBCN/uSAwV/mlCep/nRx9FE0H8lJ7yfuVG5GXQ2b5w
iwgLH+8EzfTWo495JWbHrhIh/jpvtYZ9IxKTttd5HUiE5bN6Q2KOP1H2wI7H
Ur5EyMx+uFrMerR28t9LEZ5EsDnw3sKI1YCG2REv/zoToXLojmLYjs9orWI9
dvE0Efy3rEl0i/mGjEt8N09ZEyFy7847yx++IS3Ua+RrSYQwb6shBd16RDl+
rXTZiAjPD5n2Xjb9hqIODNrc1iWCyk+r8tzgBsROyJRfr0mEj4RAvcDKL6hc
xWdXgRoROpBi6Hv8K1JsZB8yViHCmFZBHonyFUk1W3tzZInwInkwNpH7CTXQ
1XLv7SBC9VxRUpb3J5Tv93JKYxMRUg7XRtS6fUFfCJ/2ctet8vXH7tsJ/Vok
cyr/XKYoEULo2c9Ynt+RTPqDJHsGEWQObrJMcP6GCuW/P5ciEeFr2l7bSVoD
0vPLS+rjI8KBkcj/ni9/QwIlj0/nLBFApe3VivKRj8gOl170nyHA0rHllWt3
q1F77Y+TRzgEiH8btnfcuxK5o8MhW4YIcDW8aZ9mIiAIkLPl6SNA4ceyrJlv
FUj3kdl4dwcBpFIzIq9IlCCKa5hMTTMBvjZy85Lny1CWV7NAbgMBwj95z5Yv
VaNnZkNhDz8RQF3UPDefW4F+UDm1b2sJsP1ST4ZRQCUqtRlMjqkmgN1+NHms
D1DQg37NWzgBFLs0af4VFcihWPD8tdcE0PQreqywoQh1QMDW6wUESKdKCpVg
79Ae1m3zOzkEONvkHab3swJJMa7MxGUSYCLOQEZELBcNEqoIj9IJcPihysMk
9lukz4eHFCUT4MuTPZ+2bnyDxmM5Jz7HE6BK0tW+MTgPReT1RQ1EEWDlIyUr
4FQRSopU+YdwmwAtqv6UC8dfo6cudzi7wgjQ7SaSZm5ajHScHzDMgwkg2nFc
5AznMbrrLuN1+RIB7r5b2p/WFIN0uFRqrjcBvr31F5y3TMetOtZ39LkRoOLM
HvHhxWx8v41uh4QTAfa/OFCm62qOx7y7KWRtTwBtreuFb7tSUYhln9kDawKc
MLbPefssFw/a7/Gmx5IAli8exptOP0Bar9as32NOgM+/8v04suloa+J1W+1e
Ici6+OhnYHwh/nhOQUL9ohDQPOY2BEV9wC0D5dlhLCFwcRlppUp+xy8TMjwe
5AqCkl8/bfllC25vt6da1EIQguq4PPL83bjc6MctUYsC4BYcM9VG/YXLJOin
FDwVAEVNrrkM5Te+/tDTW/ssBeCJVJCt7NtBvCYnIq9NSACQ+G+8030Y/13X
ona6jB9avRLOef0zhmuzObcTvPkhxXuw3UiHg7dZ/okwlOGHc0XlXW7+E7ht
tnjl0UE+cFwatXuby8U/JWp9jnrKByZO3Jr3w5N4saPtj8Z/+eDgR94UIE7j
7ruJ5kI7+cAnx1azdPMMvmKI2RBGeaGiO/tbtvQs7krcFlOezwsJzn9OdinP
4eeSmsqY/ryg2XyNJ3nPPN6VZHJvSJMX4s0rVD7vWcC7tOsK9tB44YHThD91
8yKesuHYht6fPBB48+YfW8kl3Jk9f7TtCQ8Qt28vHxBbxnvHW8TYPjywebSJ
6UBZwQkFj2wvHuKBowTtkz19K3i8aOL6ZWEecNhIKQqFv3jGtGKwzKe/eGX7
fGzGER6QH5re7O71F68gJhc1F/OAbsHl40/E/uJeGhlaQht4AbtilYHDCj5R
riQmfZUXun3j5bJcV/CYD3xGugO8sNPaUMRw7QouU6t7wFCfD7b+LElLrFnG
3SPehzGz+SD45GvZEN9lfLGgJ+UHlR/uVV2kcbYv45/2+kpaO/PDGclBj9bW
JbwtZHbx8Wd+CFpLOaYQtYSHzD6HpC0CcCb+ZfiA1hI+lHJHdOmyALT8ifHh
LC7iH07uVj3YLgCamWx7rHARJy7LL41KC0JX9PnFT+6L+A3R4syYG4Kw2+78
vZs7FvGlFebs7TZBOOexm+bWt4BrDGm3ucsJwdC13aVu6Qu40d/UFw2BQtB1
Tc0z9NQC/mVpC4XVIAT9dl/c0yUX8EeT8QETkgRo62PYVXXO430V/d7x7gTY
V5J2sDd1Hn91oeLxzioCPA84nDRpP49XT3z4dJu+2pcOhEhObJnH70odP2Tp
QASy7fP274NzuNnEf5Pnnq32kZjtSvE5q+9C6GQAa4wI231nP8ien8NJ3GSv
yj0kmFLMuJWkOod3HRKPehhMguEo1/RvPHP46fB/zG/VkSC9dK1zw4dZnK47
nj8oRoZ7hNTHMTGzeB7xiH+oBRm0zPZtoFvP4iebjCokU8lQ4bLQr7F1Fj9v
Ne7c8Wt1jg7eu28HZwbPb+sa3S1HAd22uatvymbwvVzPA1OeFKDZZzgs3JjB
xQP3ivZkUmD+bVlyh8UMXhj5YFvSHAUkvAeJpzfN4POfo3ru76FCktZMx1XO
NB7Yl1N098LqHhz/WgPh03jd6zUoO5cKX0llEdGR07j24q/ymUUqtG45p+5j
O41fsn9dm6VKg4X6VwO/ZafxGwYz/wVeWJUtzhzu/zuFJxf4WnoU0iBLr0vO
rWEKPyQsqdM7Q4PPvL+jLz1a1ZeLha/soYOQmrEPwXcK//dclqi+Ox0c638v
iepN4TOWhar8BXToNDvumL5+Cs/ceNb+Uj8dRON3/H3KmcSJ0fEz4xIMCBAp
V9hSPYnzi6lErrFmQPmEku2apEn8xcnNvVmRDBhZixsEeE7iFKu1E6rfGaCq
fOeKifYknicy5qjEywT/s1Wv7q6bxGkXb1e6b2DCXWPTYk0uF5/0cRYMV2GC
RKKEhfVHLq7cYq+vbcWE1I/uAW1pXPxR15SDuD8T7hiobX13iYubbLxzkxXF
BKvg+1ZkUy4udkOwWCWbCeHYerminVy8dLUtD7xjgsYti1qcj4vHxe144tzD
BMH/kM2O9gmcHrj1T+DUKl73p22jRRN4azgJ/RBjQcfHk97U6AkctwhyWVJg
gcf1owlhZyfwbbTPve46LGiUeDFnrj2BtzwP8hGyYQE+GizgJzWBx3cGbrHw
Y8GT1LD13EUO7vvvwyrnJBZYf/fgljdz8J7l0+uGX7Dgzc2tS60FHNxV5tLz
8o+s1X8n6uvhaA5+Xukgg7+PBXcm+hn87hycY/Fi/igPG1wL/3Wg6HPwyeMN
b49T2bDZhy/o1PZVfaWIzcouNhS9EhZbEViNF9ywI1KbDShr9+Cn6nF8oXz0
lfFJNjjq1r6RvjKOF5l5u+07z4YIvd/G/6BxvKk7IiUgkg0vbDdZxC6N4S5Q
y5uezoa4CJvbcaVjuPAT/ZzOMjY4p2HvJPzG8JqkKr3wSjaMqdQ1Su8bw5XE
DBZf9bHhx77ZnDezo/hasZ9ikcts2HtLSbOuZBTP8LP1jmIIw1Lf2FnbS6O4
a9mNToXtwvA/I7RWOQ==
      "]]}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-5.285163187333817, -5.48568467884237},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) \
[\\!\\(\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], 
      TraditionalForm], None}},
  FrameTicks->{{{{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30], 3.4011973816621555`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70], 4.248495242049359], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90], 4.499809670330265], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[300], 5.703782474656201], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[400], 5.991464547107982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[600], 6.396929655216146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[700], 6.551080335043404], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[800], 6.684611727667927], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[900], 6.802394763324311], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2000], 7.600902459542082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3000], 8.006367567650246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4000], 8.294049640102028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5000], 8.517193191416238], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6000], 8.699514748210191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7000], 8.85366542803745], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8000], 8.987196820661973], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9000], 9.104979856318357], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30], 3.4011973816621555`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70], 4.248495242049359], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90], 4.499809670330265], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[300], 5.703782474656201], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[400], 5.991464547107982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[600], 6.396929655216146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[700], 6.551080335043404], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[800], 6.684611727667927], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[900], 6.802394763324311], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2000], 7.600902459542082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3000], 8.006367567650246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4000], 8.294049640102028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5000], 8.517193191416238], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6000], 8.699514748210191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7000], 8.85366542803745], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8000], 8.987196820661973], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9000], 9.104979856318357], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}, {{{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  LabelStyle->{FontSize -> 14, 
    GrayLevel[0]},
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{-5.285163187333817, -0.920943459371443}, {-5.48568467884237, 
   4.123646251832177}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], 
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0]}]], "Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.891426801668441*^9, 
   3.8926186413176928`*^9, 3.8926186824334993`*^9, 3.8926189121910763`*^9, 
   3.8926285278640122`*^9, 3.902311008206068*^9, 3.902311104132188*^9, 
   3.902311361239811*^9, {3.9023123510880857`*^9, 3.902312373125546*^9}},
 CellLabel->
  "Out[1723]=",ExpressionUUID->"e5533c7d-12cb-41a7-9121-a783a31918ab"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2022-08_\
new_data\\\\Analysis\\\\Full form factor fit\\\\LH-ESRF-C16 - volume (not \
corrupted)\\\\DataMerged.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.891426801668441*^9, 
   3.8926186413176928`*^9, 3.8926186824334993`*^9, 3.8926189121910763`*^9, 
   3.8926285278640122`*^9, 3.902311008206068*^9, 3.902311104132188*^9, 
   3.902311361239811*^9, {3.9023123510880857`*^9, 3.9023123740635557`*^9}},
 CellLabel->
  "Out[1724]=",ExpressionUUID->"3439e3e4-ebb0-46c2-ad1d-30cd7d7747e6"],

Cell[BoxData[
 GraphicsBox[{{
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-5.084348085637381, 4.021390253745636}, {-5.084348085637381,
          4.056479731190099}}], 
        LineBox[{{-5.084348085637381, 4.056479731190099}, {-5.084348085637381,
          4.090379563320364}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-5.025010372042255, 
         3.8823717522216015`}, {-5.025010372042255, 3.9323977517516573`}}], 
        LineBox[{{-5.025010372042255, 
         3.9323977517516573`}, {-5.025010372042255, 3.9800399302812686`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.980041374477484, 3.874261114639935}, {-4.980041374477484,
          3.885479136336902}}], 
        LineBox[{{-4.980041374477484, 3.885479136336902}, {-4.980041374477484,
          3.8965727088065942`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.937008119887209, 
         3.8081324083798918`}, {-4.937008119887209, 3.839086851237379}}], 
        LineBox[{{-4.937008119887209, 3.839086851237379}, {-4.937008119887209,
          3.869111816052016}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.885780418275388, 
         3.7228174482619396`}, {-4.885780418275388, 3.743820335327719}}], 
        LineBox[{{-4.885780418275388, 3.743820335327719}, {-4.885780418275388,
          3.7643911601277855`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.836890997791754, 3.62724602553475}, {-4.836890997791754, 
         3.659323719628273}}], 
        LineBox[{{-4.836890997791754, 3.659323719628273}, {-4.836890997791754,
          3.6904043363697996`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.7904256789098545`, 
         3.6094556396289197`}, {-4.7904256789098545`, 3.6124207638067767`}}], 
        LineBox[{{-4.7904256789098545`, 
         3.6124207638067767`}, {-4.7904256789098545`, 3.6153771220090465`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.737293643353486, 3.509496782868884}, {-4.737293643353486,
          3.5210804633917694`}}], 
        LineBox[{{-4.737293643353486, 
         3.5210804633917694`}, {-4.737293643353486, 3.5325314973296282`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.686843305597875, 
         3.4258481110297896`}, {-4.686843305597875, 3.4467576865254266`}}], 
        LineBox[{{-4.686843305597875, 
         3.4467576865254266`}, {-4.686843305597875, 3.4672389913478554`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.638816810695785, 3.371065681503043}, {-4.638816810695785,
          3.3807613927041227`}}], 
        LineBox[{{-4.638816810695785, 
         3.3807613927041227`}, {-4.638816810695785, 3.3903639990845926`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.585618618209504, 
         3.2905975853625584`}, {-4.585618618209504, 3.322836335082933}}], 
        LineBox[{{-4.585618618209504, 3.322836335082933}, {-4.585618618209504,
          3.3540681264135257`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.5349866218238715`, 
         3.1740595182628266`}, {-4.5349866218238715`, 3.1933069109451204`}}], 
        LineBox[{{-4.5349866218238715`, 
         3.1933069109451204`}, {-4.5349866218238715`, 3.21219082648062}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.486906098502099, 
         3.1006681109392016`}, {-4.486906098502099, 3.1101706478488556`}}], 
        LineBox[{{-4.486906098502099, 
         3.1101706478488556`}, {-4.486906098502099, 3.1195837358753535`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.434587362995433, 
         2.9943503115991286`}, {-4.434587362995433, 3.0127524214796875`}}], 
        LineBox[{{-4.434587362995433, 
         3.0127524214796875`}, {-4.434587362995433, 3.0308220037084324`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.384870809286841, 
         2.8892101062464226`}, {-4.384870809286841, 2.908272592015705}}], 
        LineBox[{{-4.384870809286841, 2.908272592015705}, {-4.384870809286841,
          2.9269784863445905`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.331793922235689, 2.82955410769011}, {-4.331793922235689, 
         2.840738477827915}}], 
        LineBox[{{-4.331793922235689, 2.840738477827915}, {-4.331793922235689,
          2.85179914014907}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.281298916050743, 
         2.7737741315267304`}, {-4.281298916050743, 2.7895360861172565`}}], 
        LineBox[{{-4.281298916050743, 
         2.7895360861172565`}, {-4.281298916050743, 2.805053451710781}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.233317532819553, 
         2.6862718073430707`}, {-4.233317532819553, 2.6955618397527084`}}], 
        LineBox[{{-4.233317532819553, 
         2.6955618397527084`}, {-4.233317532819553, 2.7047663612499853`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.182528650278334, 
         2.5730572693880474`}, {-4.182528650278334, 2.591659981908015}}], 
        LineBox[{{-4.182528650278334, 2.591659981908015}, {-4.182528650278334,
          2.6099229441724634`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.134195560414886, 2.503344055844009}, {-4.134195560414886,
          2.512183456640269}}], 
        LineBox[{{-4.134195560414886, 2.512183456640269}, {-4.134195560414886,
          2.5209454065496417`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.083632876366685, 2.385729772586166}, {-4.083632876366685,
          2.4037073189675944`}}], 
        LineBox[{{-4.083632876366685, 
         2.4037073189675944`}, {-4.083632876366685, 2.4213673725174454`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.031202073622229, 
         2.3122252340691336`}, {-4.031202073622229, 2.32904300774497}}], 
        LineBox[{{-4.031202073622229, 2.32904300774497}, {-4.031202073622229, 
         2.345582615591575}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.9813843596872887`, 
         2.2130810067080646`}, {-3.9813843596872887`, 2.2297769278709616`}}], 
        LineBox[{{-3.9813843596872887`, 
         2.2297769278709616`}, {-3.9813843596872887`, 2.2461986667123717`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.9339315540729225`, 
         2.096287041882176}, {-3.9339315540729225`, 2.1168429550305077`}}], 
        LineBox[{{-3.9339315540729225`, 
         2.1168429550305077`}, {-3.9339315540729225`, 2.136984819477058}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.8849743942398893`, 
         2.0065855120328795`}, {-3.8849743942398893`, 2.0303445767808586`}}], 
        LineBox[{{-3.8849743942398893`, 
         2.0303445767808586`}, {-3.8849743942398893`, 2.053552224194723}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.8347700755229908`, 
         1.8999354818632646`}, {-3.8347700755229908`, 1.9126866429199154`}}], 
        LineBox[{{-3.8347700755229908`, 
         1.9126866429199154`}, {-3.8347700755229908`, 1.9252772568822294`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.7836656131917032`, 
         1.8157604884885807`}, {-3.7836656131917032`, 1.824303574045115}}], 
        LineBox[{{-3.7836656131917032`, 
         1.824303574045115}, {-3.7836656131917032`, 1.8327742930877375`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.7318587542877983`, 
         1.6697294320676583`}, {-3.7318587542877983`, 1.6847008998644861`}}], 
        LineBox[{{-3.7318587542877983`, 
         1.6847008998644861`}, {-3.7318587542877983`, 1.69945152508665}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.6826046446528315`, 
         1.578304300033921}, {-3.6826046446528315`, 1.589389933449115}}], 
        LineBox[{{-3.6826046446528315`, 
         1.589389933449115}, {-3.6826046446528315`, 1.6003540217693781`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.6328247148137414`, 
         1.4843103440623633`}, {-3.6328247148137414`, 1.4989668738068938`}}], 
        LineBox[{{-3.6328247148137414`, 
         1.4989668738068938`}, {-3.6328247148137414`, 1.5134116889534246`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.582661256928897, 
         1.3892921400472547`}, {-3.582661256928897, 1.4069140330939243`}}], 
        LineBox[{{-3.582661256928897, 
         1.4069140330939243`}, {-3.582661256928897, 1.4242307647868122`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.5323280693679435`, 
         1.3027262451117732`}, {-3.5323280693679435`, 1.3145485820331833`}}], 
        LineBox[{{-3.5323280693679435`, 
         1.3145485820331833`}, {-3.5323280693679435`, 1.3262327828062925`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.4819260190211643`, 
         1.1819078698095495`}, {-3.4819260190211643`, 1.1948649466059276`}}], 
        LineBox[{{-3.4819260190211643`, 
         1.1948649466059276`}, {-3.4819260190211643`, 1.2076562827879547`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.4339433400456847`, 
         1.0858537560981827`}, {-3.4339433400456847`, 1.1001911092771612`}}], 
        LineBox[{{-3.4339433400456847`, 
         1.1001911092771612`}, {-3.4339433400456847`, 1.1143258049103548`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.383729549397733, 
         0.9687210164211676}, {-3.383729549397733, 0.979421693725143}}], 
        LineBox[{{-3.383729549397733, 0.979421693725143}, {-3.383729549397733,
          0.9900090777792647}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.3337423956288244`, 
         0.8688347668651045}, {-3.3337423956288244`, 0.8813420085421828}}], 
        LineBox[{{-3.3337423956288244`, 
         0.8813420085421828}, {-3.3337423956288244`, 0.8936947495133952}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.284167120918414, 0.750559753006227}, {-3.284167120918414,
          0.7602039686897286}}], 
        LineBox[{{-3.284167120918414, 
         0.7602039686897286}, {-3.284167120918414, 0.7697560612253737}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.233062016517094, 
         0.6592713670216815}, {-3.233062016517094, 0.6745193274296407}}], 
        LineBox[{{-3.233062016517094, 
         0.6745193274296407}, {-3.233062016517094, 0.6895382751470022}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.1826340373457827`, 
         0.569049945135606}, {-3.1826340373457827`, 0.5792718394544509}}], 
        LineBox[{{-3.1826340373457827`, 
         0.5792718394544509}, {-3.1826340373457827`, 0.5893903030166132}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.1328778939592064`, 
         0.45685397405039124`}, {-3.1328778939592064`, 0.4678900868910863}}], 
        LineBox[{{-3.1328778939592064`, 
         0.4678900868910863}, {-3.1328778939592064`, 0.478805732228757}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.083842293493626, 
         0.35124400606114775`}, {-3.083842293493626, 0.362738259935936}}], 
        LineBox[{{-3.083842293493626, 0.362738259935936}, {-3.083842293493626,
          0.3741018958725985}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.033953781539961, 
         0.24475518170440339`}, {-3.033953781539961, 0.2525452505306486}}], 
        LineBox[{{-3.033953781539961, 
         0.2525452505306486}, {-3.033953781539961, 0.26027510297219214`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.9829211452899216`, 
         0.1498808804956121}, {-2.9829211452899216`, 0.16446606062018584`}}], 
        LineBox[{{-2.9829211452899216`, 
         0.16446606062018584`}, {-2.9829211452899216`, 
         0.17884156772085194`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.935437193039225, 
         0.024666004897671488`}, {-2.935437193039225, 0.03892221236156202}}], 
        LineBox[{{-2.935437193039225, 
         0.03892221236156202}, {-2.935437193039225, 0.05297803377320798}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.734894278728679, -0.4027306892199045}, \
{-2.734894278728679, -0.3500378023925535}}], 
        LineBox[{{-2.734894278728679, -0.3500378023925535}, \
{-2.734894278728679, -0.2999830259978416}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.4849223397830356`, -0.9415007193952571}, \
{-2.4849223397830356`, -0.8988836272530292}}], 
        LineBox[{{-2.4849223397830356`, -0.8988836272530292}, \
{-2.4849223397830356`, -0.8580087561448758}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.380038563220422, -1.168886431219446}, \
{-2.380038563220422, -1.1302696478938354`}}], 
        LineBox[{{-2.380038563220422, -1.1302696478938354`}, \
{-2.380038563220422, -1.0930888395888656`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.2851211182798545`, -1.3843332624579716`}, \
{-2.2851211182798545`, -1.3491796839550345`}}], 
        LineBox[{{-2.2851211182798545`, -1.3491796839550345`}, \
{-2.2851211182798545`, -1.3152200276640662`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.226506167649257, -1.513443915577809}, \
{-2.226506167649257, -1.4805355958399486`}}], 
        LineBox[{{-2.226506167649257, -1.4805355958399486`}, \
{-2.226506167649257, -1.4486758194187817`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.144562997373256, -1.6964808470883848`}, \
{-2.144562997373256, -1.6672175837719347`}}], 
        LineBox[{{-2.144562997373256, -1.6672175837719347`}, \
{-2.144562997373256, -1.638786368286216}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.0934424039470523`, -1.8188098081823985`}, \
{-2.0934424039470523`, -1.78787548595345}}], 
        LineBox[{{-2.0934424039470523`, -1.78787548595345}, \
{-2.0934424039470523`, -1.757869451853188}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.0331259247878006`, -1.9623442356846974`}, \
{-2.0331259247878006`, -1.9310525682429114`}}], 
        LineBox[{{-2.0331259247878006`, -1.9310525682429114`}, \
{-2.0331259247878006`, -1.9007104319636563`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.976025406568619, -2.089614251106696}, \
{-1.976025406568619, -2.063593181154233}}], 
        LineBox[{{-1.976025406568619, -2.063593181154233}, \
{-1.976025406568619, -2.0382320707227337`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.9326653384575119`, -2.1893508765055896`}, \
{-1.9326653384575119`, -2.1645978534069954`}}], 
        LineBox[{{-1.9326653384575119`, -2.1645978534069954`}, \
{-1.9326653384575119`, -2.140442771403275}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.8810672419769725`, -2.3142044837412943`}, \
{-1.8810672419769725`, -2.2860749961801106`}}], 
        LineBox[{{-1.8810672419769725`, -2.2860749961801106`}, \
{-1.8810672419769725`, -2.2587151757090957`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.8318406272528898`, -2.426208435569265}, \
{-1.8318406272528898`, -2.403611884800499}}], 
        LineBox[{{-1.8318406272528898`, -2.403611884800499}, \
{-1.8318406272528898`, -2.3815146755201932`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.7850708398172375`, -2.5440353718334876`}, \
{-1.7850708398172375`, -2.5184299602608564`}}], 
        LineBox[{{-1.7850708398172375`, -2.5184299602608564`}, \
{-1.7850708398172375`, -2.493463850265984}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.7316070609965282`, -2.6728610755007756`}, \
{-1.7316070609965282`, -2.6483954516048827`}}], 
        LineBox[{{-1.7316070609965282`, -2.6483954516048827`}, \
{-1.7316070609965282`, -2.624514127647388}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.680857774871063, -2.7951027012073832`}, \
{-1.680857774871063, -2.772101404678041}}], 
        LineBox[{{-1.680857774871063, -2.772101404678041}, \
{-1.680857774871063, -2.749617294131161}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.632560487956873, -2.9125422624052786`}, \
{-1.632560487956873, -2.8902333419217077`}}], 
        LineBox[{{-1.632560487956873, -2.8902333419217077`}, \
{-1.632560487956873, -2.868411268098209}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.5864890309770467`, -3.0315029104150426`}, \
{-1.5864890309770467`, -3.0087952313045534`}}], 
        LineBox[{{-1.5864890309770467`, -3.0087952313045534`}, \
{-1.5864890309770467`, -2.9865917626203404`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.5353513680587525`, -3.1570922475325345`}, \
{-1.5353513680587525`, -3.134386745733925}}], 
        LineBox[{{-1.5353513680587525`, -3.134386745733925}, \
{-1.5353513680587525`, -3.1121853587437736`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.4798745637368198`, -3.2985070757929527`}, \
{-1.4798745637368198`, -3.2766200353267574`}}], 
        LineBox[{{-1.4798745637368198`, -3.2766200353267574`}, \
{-1.4798745637368198`, -3.2552017950652057`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.4336874114561198`, -3.4162841265054915`}, \
{-1.4336874114561198`, -3.3963213469751037`}}], 
        LineBox[{{-1.4336874114561198`, -3.3963213469751037`}, \
{-1.4336874114561198`, -3.37674929276931}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.3835443794448625`, -3.547640932874873}, \
{-1.3835443794448625`, -3.5247391017646366`}}], 
        LineBox[{{-1.3835443794448625`, -3.5247391017646366`}, \
{-1.3835443794448625`, -3.5023500430065866`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.329822772449285, -3.687430836430992}, \
{-1.329822772449285, -3.6679127403357334`}}], 
        LineBox[{{-1.329822772449285, -3.6679127403357334`}, \
{-1.329822772449285, -3.648768318540228}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.2844243515113174`, -3.8105066020329232`}, \
{-1.2844243515113174`, -3.7907934814181834`}}], 
        LineBox[{{-1.2844243515113174`, -3.7907934814181834`}, \
{-1.2844243515113174`, -3.771461467233683}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.2357418538566787`, -3.9393223994725814`}, \
{-1.2357418538566787`, -3.9187872788897584`}}], 
        LineBox[{{-1.2357418538566787`, -3.9187872788897584`}, \
{-1.2357418538566787`, -3.8986653781925473`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.1842463978924687`, -4.079081385213644}, \
{-1.1842463978924687`, -4.058115283303484}}], 
        LineBox[{{-1.1842463978924687`, -4.058115283303484}, \
{-1.1842463978924687`, -4.037579746988491}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.1352739017580313`, -4.209109352236573}, \
{-1.1352739017580313`, -4.191226542932226}}], 
        LineBox[{{-1.1352739017580313`, -4.191226542932226}, \
{-1.1352739017580313`, -4.173657918219016}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.0840754969609638`, -4.352701378355831}, \
{-1.0840754969609638`, -4.333498579565102}}], 
        LineBox[{{-1.0840754969609638`, -4.333498579565102}, \
{-1.0840754969609638`, -4.314657591387746}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.0310183660733363`, -4.500803358285759}, \
{-1.0310183660733363`, -4.48247904250758}}], 
        LineBox[{{-1.0310183660733363`, -4.48247904250758}, \
{-1.0310183660733363`, -4.464484473946707}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-0.9806356434778151, -4.642961383252678}, \
{-0.9806356434778151, -4.625173953253483}}], 
        LineBox[{{-0.9806356434778151, -4.625173953253483}, \
{-0.9806356434778151, -4.607697394375036}}]}},
      Antialiasing->False]}}, 
   {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.011000000000000001`], 
    AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJwVxXk4lHkcAPAxM5gx5jKE5FhHuUohRLxvrh5X7msJtVqFKFt45IqyGCEl
V7ZaJcSmkK71+xZqMdmOZ0KWRWXdx5hxpWl3//g8n+8Ox3odIRIIBK///H+X
we6AUD95aAkve8vfw8I/zN72vKosDzuU+Ut5p5m4fYzHSsE0B7oHhxXiFZg4
k5jMSEMcKOF26P/0gIF7PLwmKcPlQGFNHCdgiY6H+GwTrgVwIMmmLtPFkY6n
BfwQeESPAwrZaYN7x2VxkUTf5q8COdj3ZtzK0EAW/5uzMeCN5EBpovqeqIiG
G7kkinXy5WBeQL3Bo9HwwQumR+v95WCX5jFzg2IZvEc9LvudlhyIeOGpn7hU
PEpXJ7NEwIZT07StN0YpuHC/dSL5dzY8LaMuqm6m4B1OvCKVXDaoJTdHadtL
40YM065n3mwY5/gp8R9J4e7fN72V1WBDpMJtl1UPKTzG8HL31BwLRHWvH2UU
SuJbVUO6Jx6z4JXhecuHT8i4H6GyIDKHBf2XhquWlMi4Yrz3YJUvC3TXNP7p
tiThp5RbY5fUWTA0P+k6eoOIH3ej00YGmKBbbepU/F4Cbyl0UbmXyASSWBjk
Mk/AbeKzTx2XZ8IKZ5urjg0BfxexMFfRwIDr4dvdD5aLsc92qkkCewY0i18u
Buz8irXVmLf3f6CDYtD+uWzhOsal/xy9dpoOvE15Wtoxa9j0q5MRUiw6nKtw
bez4soKZY8oHnGtlYQVJOT/MWMbeRUta7LaVBWIoXSmcIsK4rn7SGx9ocEfA
a9ZXW8LOnN3h1JpIg70aKuJD5YtYVJgTb4RNg+SgRb1o/3nsrqq85tk7MvBA
MLFNaDKD/cj1P7bmIAOm62sOJd4T2FOa/y/uQ1QwupiUX1v8GZtyzuNT4qmQ
H9WmdCRnDHPwkXbSZFGBn+BjN7k4hJlUame03KHA8P3B7M3mfZilZ2RBjgMF
HDMFF5r0XmNhOTPPJYekgWPKd99D78T0s56mvjgjDc8qgh9fna3CdMqyQhzG
pKAmoao/ubgZ3Vzdpbo3QQroMavqKQV/oKl9x3DWqCS4LR4VkiPeo0NhZp0K
PpKQ0isg7CSNIKPZLu2CL2SITr0oHJT9iAxLnCubqslgbCvwNqSNoy121TkW
vmS4pZESsqNtAvm1NS2rjZIgr7Ot9Hb7DHKQW8gtiSNBZdzEXwccF9AWiYwa
TxkSTPf7Xi9WEKCeMnteQTURPCIEL15OL6Eip6bLs/uJEGjVGGt9RYSa9U0S
xv6UgHrtHkXHxhV0spz/hJUkAbZ95wkVZmso9ATzFktXAkqHAgNm6tcRUVn3
SQgiwPM+f2+tig2kNxGc1WdHgGvBrWEln8VoMlb+Da/yG3oe56xtnUGAjvLo
FOMZMWr8NtWg5CkB4R+HlgeUxIgeJtU46kSE3EIlNQv3r+ijyGC41JIEz+ZG
TlQXbCDF++EVbTpk8KFRKmqbvyBVnWDhpJEk9L+wV+/5tI4y3bzS7bZLwYgd
Ba2oraOT47k1xurSkKCT6GV7eA01ZixbkeQoYDJeXsorXEVR3LtBezhUUJ70
WypsWEHXDGsLz5nJAL6PYXZ4YRl1taKsOgMaqCSHx3zTXEaVipTIOmNZmPDx
shE6itDqlYxfx/zpkMhPzSNcECJGdXg215sBFr1UvKxzCf2WtkmnIZAJvbX8
wHqBALW03SzKsGKB/0D6iry+AOUrsD69bmcBMelgXmjAIjqx/qY63ZcN8+3W
qvS0BWTnFrfBmGPDrTmcEHJoHl3S6i3bni4H/wJTLoGd
     "]]}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-5.257117229252595, -5.326394874292732},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) \
[\\!\\(\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], 
      TraditionalForm], None}},
  FrameTicks->{{{{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30], 3.4011973816621555`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70], 4.248495242049359], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90], 4.499809670330265], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[300], 5.703782474656201], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[400], 5.991464547107982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[600], 6.396929655216146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[700], 6.551080335043404], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[800], 6.684611727667927], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[900], 6.802394763324311], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30], 3.4011973816621555`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70], 4.248495242049359], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90], 4.499809670330265], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[300], 5.703782474656201], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[400], 5.991464547107982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[600], 6.396929655216146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[700], 6.551080335043404], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[800], 6.684611727667927], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[900], 6.802394763324311], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}, {{{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  LabelStyle->{FontSize -> 14, 
    GrayLevel[0]},
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{-5.257117229252595, -0.9806356434778151}, {-5.326394874292732, 
   4.090379563320364}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], 
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0]}]], "Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.891426801668441*^9, 
   3.8926186413176928`*^9, 3.8926186824334993`*^9, 3.8926189121910763`*^9, 
   3.8926285278640122`*^9, 3.902311008206068*^9, 3.902311104132188*^9, 
   3.902311361239811*^9, {3.9023123510880857`*^9, 3.9023123742743216`*^9}},
 CellLabel->
  "Out[1726]=",ExpressionUUID->"8e2a69c3-08b2-4762-a104-d3af3a8a8dbd"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2022-08_\
new_data\\\\Analysis\\\\Full form factor fit\\\\LH-ESRF-C16 - volume (not \
corrupted)\\\\DataMergedBinned.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.891426801668441*^9, 
   3.8926186413176928`*^9, 3.8926186824334993`*^9, 3.8926189121910763`*^9, 
   3.8926285278640122`*^9, 3.902311008206068*^9, 3.902311104132188*^9, 
   3.902311361239811*^9, {3.9023123510880857`*^9, 3.902312374912302*^9}},
 CellLabel->
  "Out[1727]=",ExpressionUUID->"e6d3c8ef-b65c-44e7-80f5-f76db520509a"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2022-08_\
new_data\\\\Analysis\\\\Full form factor fit\\\\LH-ESRF-C16 - volume (not \
corrupted)\\\\Sample playground LH-ESRF-C16 NEW SAXS data merged and \
binned.csv\"\>"], "Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.891426801668441*^9, 
   3.8926186413176928`*^9, 3.8926186824334993`*^9, 3.8926189121910763`*^9, 
   3.8926285278640122`*^9, 3.902311008206068*^9, 3.902311104132188*^9, 
   3.902311361239811*^9, {3.9023123510880857`*^9, 3.9023123749976673`*^9}},
 CellLabel->
  "Out[1729]=",ExpressionUUID->"f75583ad-f9a4-48db-87e5-4be954787aad"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Plot", " ", "slopes"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"plotSlopes", "=", " ", 
    RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"slope", "[", 
       RowBox[{"datamerged", ",", "0.15"}], "]"}], ",", " ", 
      RowBox[{"(*", " ", 
       RowBox[{"default", ":", " ", "0.15"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", " ", 
            RowBox[{"10", "^", 
             RowBox[{"-", "3"}]}]}], ",", " ", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "6"}], ",", "0"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", " ", "Automatic"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"PowerTicks", "[", "True", "]"}], "[", 
            RowBox[{
             RowBox[{"10", "^", 
              RowBox[{"-", "2"}]}], ",", " ", 
             RowBox[{"10", "^", "0"}]}], "]"}], ",", 
           RowBox[{
            RowBox[{"PowerTicks", "[", "False", "]"}], "[", 
            RowBox[{
             RowBox[{"10", "^", 
              RowBox[{"-", "2"}]}], ",", " ", 
             RowBox[{"10", "^", "0"}]}], "]"}]}], "}"}]}], "}"}]}], ",", " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
        " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
        "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Slope\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}]}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<Slopes.pdf\>\""}], "}"}], "]"}], ",", "plotSlopes"}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"slope", "[", 
    RowBox[{"datamerged", ",", "0.15"}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Export", " ", "slopes", " ", 
     RowBox[{"(", 
      RowBox[{
      "for", " ", "plotting", " ", "in", " ", "Python", " ", "or", " ", 
       "other", " ", "software"}], ")"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"exportlist", " ", "=", " ", 
     RowBox[{"exportData", "[", 
      RowBox[{"slope", "[", 
       RowBox[{"datamerged", ",", "0.15"}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", "\[IndentingNewLine]", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"FileBaseName", "[", 
          RowBox[{"NotebookFileName", "[", "]"}], "]"}], "<>", 
         "\"\< SAXS slopes.csv\>\""}]}], "\[IndentingNewLine]", "}"}], 
      "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
     "exportlist"}], "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
   RowBox[{"NotebookFileName", "[", "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.852797516969694*^9, {3.852797632109549*^9, 3.852797683131383*^9}, {
   3.852797796480151*^9, 3.852797853718195*^9}, {3.8527978838837643`*^9, 
   3.852797901227326*^9}, {3.852797980320817*^9, 3.852798038102087*^9}, 
   3.852798223135673*^9, {3.852798406664549*^9, 3.852798409306513*^9}, {
   3.852798512004775*^9, 3.852798555547234*^9}, {3.85279858828354*^9, 
   3.852798831366269*^9}, {3.852798896028565*^9, 3.852799007753936*^9}, {
   3.852799080350028*^9, 3.852799084748775*^9}, {3.8527992586158037`*^9, 
   3.8527992606884203`*^9}, {3.852801934781908*^9, 3.85280197103442*^9}, {
   3.852802103164875*^9, 3.852802118419861*^9}, {3.852862635200562*^9, 
   3.8528626398081703`*^9}, {3.85286268207966*^9, 3.85286275183375*^9}, {
   3.852862799533414*^9, 3.852862876114451*^9}, {3.8528629338179607`*^9, 
   3.852862985846582*^9}, {3.852863040437448*^9, 3.852863051004711*^9}, {
   3.852868510428824*^9, 3.852868602768145*^9}, {3.852868644287572*^9, 
   3.85286868020261*^9}, {3.852868718724351*^9, 3.85286873785894*^9}, {
   3.852868770378528*^9, 3.8528689132597523`*^9}, {3.852868965432905*^9, 
   3.852868981650947*^9}, 3.852870677134739*^9, {3.8528710993603067`*^9, 
   3.852871145669981*^9}, {3.8528716178560038`*^9, 3.852871618411791*^9}, {
   3.852874052533587*^9, 3.852874070324737*^9}, {3.8533820192129173`*^9, 
   3.853382032526078*^9}, {3.853403584226432*^9, 3.853403584753387*^9}, {
   3.8534051467395353`*^9, 3.853405196243081*^9}, {3.853405235261485*^9, 
   3.8534052353804817`*^9}, {3.853405414194544*^9, 3.85340541704944*^9}, {
   3.854423706814918*^9, 3.854423713174549*^9}, {3.8601401065322495`*^9, 
   3.8601401162752795`*^9}, {3.8617652315248656`*^9, 3.861765245785426*^9}, {
   3.861765486245756*^9, 3.861765500810083*^9}, {3.8617668960181065`*^9, 
   3.861766896503375*^9}, {3.861766959391518*^9, 3.861766970643777*^9}, {
   3.861768170754223*^9, 3.861768171551543*^9}, {3.861768267366991*^9, 
   3.8617682678668547`*^9}, 3.861940907625001*^9, {3.861941874731223*^9, 
   3.8619418752572*^9}, {3.863686273326891*^9, 3.86368627384243*^9}, 
   3.863687238834276*^9, {3.8895154361670246`*^9, 3.889515452084921*^9}, {
   3.889672427830373*^9, 3.8896724458079796`*^9}, {3.8896763888939342`*^9, 
   3.8896765605915513`*^9}, 3.889676629643072*^9, {3.88967679120571*^9, 
   3.88967681543388*^9}, {3.889676858823769*^9, 3.889676888283419*^9}, {
   3.8926186490246143`*^9, 3.8926186508161917`*^9}},
 CellLabel->
  "In[1730]:=",ExpressionUUID->"8edd1d77-e6da-4feb-ad70-9ef9a39ee410"],

Cell[BoxData[
 GraphicsBox[{{{
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-4.962020517152551, -1.7975229365155172`}, \
{-4.962020517152551, -1.4904522790582342`}}], 
         LineBox[{{-4.962020517152551, -1.4904522790582342`}, \
{-4.962020517152551, -1.1833816216009512`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-4.812318020609066, -1.7499804854261338`}, \
{-4.812318020609066, -1.484844590276649}}], 
         LineBox[{{-4.812318020609066, -1.484844590276649}, \
{-4.812318020609066, -1.219708695127164}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-4.662288009830052, -1.731832308155819}, \
{-4.662288009830052, -1.484844094732198}}], 
         LineBox[{{-4.662288009830052, -1.484844094732198}, \
{-4.662288009830052, -1.237855881308577}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-4.510921616983912, -2.1820005297355953`}, \
{-4.510921616983912, -1.9277101971080235`}}], 
         LineBox[{{-4.510921616983912, -1.9277101971080235`}, \
{-4.510921616983912, -1.6734198644804519`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-4.358825697731176, -1.7496301838784403`}, \
{-4.358825697731176, -1.5407870885745718`}}], 
         LineBox[{{-4.358825697731176, -1.5407870885745718`}, \
{-4.358825697731176, -1.3319439932707033`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-4.206267641506683, -2.0186112646490657`}, \
{-4.206267641506683, -1.8301249552977674`}}], 
         LineBox[{{-4.206267641506683, -1.8301249552977674`}, \
{-4.206267641506683, -1.6416386459464691`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-4.056255653469975, -2.045423498599775}, \
{-4.056255653469975, -1.8298421264932705`}}], 
         LineBox[{{-4.056255653469975, -1.8298421264932705`}, \
{-4.056255653469975, -1.6142607543867664`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-3.9071666992729934`, -2.2539753896725387`}, \
{-3.9071666992729934`, -2.048083845765819}}], 
         LineBox[{{-3.9071666992729934`, -2.048083845765819}, \
{-3.9071666992729934`, -1.8421923018590989`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-3.7563029605395606`, -2.356016322351946}, \
{-3.7563029605395606`, -2.1793864693343323`}}], 
         LineBox[{{-3.7563029605395606`, -2.1793864693343323`}, \
{-3.7563029605395606`, -2.0027566163167188`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-3.6055069407082008`, -2.0712591417540867`}, \
{-3.6055069407082008`, -1.9041921854873916`}}], 
         LineBox[{{-3.6055069407082008`, -1.9041921854873916`}, \
{-3.6055069407082008`, -1.7371252292206965`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-3.4564260807134493`, -2.3154337014558}, \
{-3.4564260807134493`, -2.1486849495091764`}}], 
         LineBox[{{-3.4564260807134493`, -2.1486849495091764`}, \
{-3.4564260807134493`, -1.9819361975625527`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-3.3071524238710044`, -2.236134018237064}, \
{-3.3071524238710044`, -2.0916457307990073`}}], 
         LineBox[{{-3.3071524238710044`, -2.0916457307990073`}, \
{-3.3071524238710044`, -1.9471574433609504`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-3.156690529396256, -2.207572101104361}, \
{-3.156690529396256, -2.0758943792454656`}}], 
         LineBox[{{-3.156690529396256, -2.0758943792454656`}, \
{-3.156690529396256, -1.9442166573865698`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-3.0195378319942416`, -2.242122341649085}, \
{-3.0195378319942416`, -2.0720360768688115`}}], 
         LineBox[{{-3.0195378319942416`, -2.0720360768688115`}, \
{-3.0195378319942416`, -1.9019498120885379`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-2.8585261080745212`, -2.317698131453854}, \
{-2.8585261080745212`, -2.0032105152590582`}}], 
         LineBox[{{-2.8585261080745212`, -2.0032105152590582`}, \
{-2.8585261080745212`, -1.6887228990642622`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-2.691382454472379, -2.78784802624227}, \
{-2.691382454472379, -2.1892779813885275`}}], 
         LineBox[{{-2.691382454472379, -2.1892779813885275`}, \
{-2.691382454472379, -1.5907079365347847`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-2.5545155316419494`, -2.7417402803813147`}, \
{-2.5545155316419494`, -2.1924652191783975`}}], 
         LineBox[{{-2.5545155316419494`, -2.1924652191783975`}, \
{-2.5545155316419494`, -1.6431901579754804`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-2.408966023604327, -2.7235790038725742`}, \
{-2.408966023604327, -2.242770317295063}}], 
         LineBox[{{-2.408966023604327, -2.242770317295063}, \
{-2.408966023604327, -1.7619616307175516`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-2.2588388882868426`, -2.729795390355834}, \
{-2.2588388882868426`, -2.268822869979683}}], 
         LineBox[{{-2.2588388882868426`, -2.268822869979683}, \
{-2.2588388882868426`, -1.807850349603532}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-2.1096964413451786`, -2.7535327288177047`}, \
{-2.1096964413451786`, -2.3379921382936306`}}], 
         LineBox[{{-2.1096964413451786`, -2.3379921382936306`}, \
{-2.1096964413451786`, -1.9224515477695563`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-1.9578947894818906`, -2.7345648695754594`}, \
{-1.9578947894818906`, -2.3436357189221946`}}], 
         LineBox[{{-1.9578947894818906`, -2.3436357189221946`}, \
{-1.9578947894818906`, -1.9527065682689297`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-1.8071283500440232`, -2.7889862251377617`}, \
{-1.8071283500440232`, -2.4214478851744476`}}], 
         LineBox[{{-1.8071283500440232`, -2.4214478851744476`}, \
{-1.8071283500440232`, -2.0539095452111336`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-1.65618364739931, -2.81505323267394}, {-1.65618364739931, \
-2.4706079244040438`}}], 
         LineBox[{{-1.65618364739931, -2.4706079244040438`}, \
{-1.65618364739931, -2.1261626161341476`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-1.5040228008910033`, -2.875105173039695}, \
{-1.5040228008910033`, -2.5481456990090083`}}], 
         LineBox[{{-1.5040228008910033`, -2.5481456990090083`}, \
{-1.5040228008910033`, -2.2211862249783216`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-1.3539296288670801`, -2.956534168031409}, \
{-1.3539296288670801`, -2.6412677590483873`}}], 
         LineBox[{{-1.3539296288670801`, -2.6412677590483873`}, \
{-1.3539296288670801`, -2.326001350065366}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-1.2055237319284868`, -3.0030836819866935`}, \
{-1.2055237319284868`, -2.702590293800939}}], 
         LineBox[{{-1.2055237319284868`, -2.702590293800939}, \
{-1.2055237319284868`, -2.4020969056151844`}}]}},
       Antialiasing->False]}}, {
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.962020517152551, -1.1833816216009512`}, 
            Offset[{3, 
             0}, {-4.962020517152551, -1.1833816216009512`}]}, \
{{-4.962020517152551, -1.1833816216009512`}, 
            Offset[{-3, 
             0}, {-4.962020517152551, -1.1833816216009512`}]}, \
{{-4.962020517152551, -1.7975229365155172`}, 
            Offset[{3, 
             0}, {-4.962020517152551, -1.7975229365155172`}]}, \
{{-4.962020517152551, -1.7975229365155172`}, 
            Offset[{-3, 
             0}, {-4.962020517152551, -1.7975229365155172`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.812318020609066, -1.219708695127164}, 
            Offset[{3, 
             0}, {-4.812318020609066, -1.219708695127164}]}, \
{{-4.812318020609066, -1.219708695127164}, 
            Offset[{-3, 
             0}, {-4.812318020609066, -1.219708695127164}]}, \
{{-4.812318020609066, -1.7499804854261338`}, 
            Offset[{3, 
             0}, {-4.812318020609066, -1.7499804854261338`}]}, \
{{-4.812318020609066, -1.7499804854261338`}, 
            Offset[{-3, 
             0}, {-4.812318020609066, -1.7499804854261338`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.662288009830052, -1.237855881308577}, 
            Offset[{3, 
             0}, {-4.662288009830052, -1.237855881308577}]}, \
{{-4.662288009830052, -1.237855881308577}, 
            Offset[{-3, 
             0}, {-4.662288009830052, -1.237855881308577}]}, \
{{-4.662288009830052, -1.731832308155819}, 
            Offset[{3, 
             0}, {-4.662288009830052, -1.731832308155819}]}, \
{{-4.662288009830052, -1.731832308155819}, 
            Offset[{-3, 0}, {-4.662288009830052, -1.731832308155819}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.510921616983912, -1.6734198644804519`}, 
            Offset[{3, 
             0}, {-4.510921616983912, -1.6734198644804519`}]}, \
{{-4.510921616983912, -1.6734198644804519`}, 
            Offset[{-3, 
             0}, {-4.510921616983912, -1.6734198644804519`}]}, \
{{-4.510921616983912, -2.1820005297355953`}, 
            Offset[{3, 
             0}, {-4.510921616983912, -2.1820005297355953`}]}, \
{{-4.510921616983912, -2.1820005297355953`}, 
            Offset[{-3, 
             0}, {-4.510921616983912, -2.1820005297355953`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.358825697731176, -1.3319439932707033`}, 
            Offset[{3, 
             0}, {-4.358825697731176, -1.3319439932707033`}]}, \
{{-4.358825697731176, -1.3319439932707033`}, 
            Offset[{-3, 
             0}, {-4.358825697731176, -1.3319439932707033`}]}, \
{{-4.358825697731176, -1.7496301838784403`}, 
            Offset[{3, 
             0}, {-4.358825697731176, -1.7496301838784403`}]}, \
{{-4.358825697731176, -1.7496301838784403`}, 
            Offset[{-3, 
             0}, {-4.358825697731176, -1.7496301838784403`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.206267641506683, -1.6416386459464691`}, 
            Offset[{3, 
             0}, {-4.206267641506683, -1.6416386459464691`}]}, \
{{-4.206267641506683, -1.6416386459464691`}, 
            Offset[{-3, 
             0}, {-4.206267641506683, -1.6416386459464691`}]}, \
{{-4.206267641506683, -2.0186112646490657`}, 
            Offset[{3, 
             0}, {-4.206267641506683, -2.0186112646490657`}]}, \
{{-4.206267641506683, -2.0186112646490657`}, 
            Offset[{-3, 
             0}, {-4.206267641506683, -2.0186112646490657`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.056255653469975, -1.6142607543867664`}, 
            Offset[{3, 
             0}, {-4.056255653469975, -1.6142607543867664`}]}, \
{{-4.056255653469975, -1.6142607543867664`}, 
            Offset[{-3, 
             0}, {-4.056255653469975, -1.6142607543867664`}]}, \
{{-4.056255653469975, -2.045423498599775}, 
            Offset[{3, 
             0}, {-4.056255653469975, -2.045423498599775}]}, \
{{-4.056255653469975, -2.045423498599775}, 
            Offset[{-3, 0}, {-4.056255653469975, -2.045423498599775}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.9071666992729934`, -1.8421923018590989`}, 
            Offset[{3, 
             0}, {-3.9071666992729934`, -1.8421923018590989`}]}, \
{{-3.9071666992729934`, -1.8421923018590989`}, 
            Offset[{-3, 
             0}, {-3.9071666992729934`, -1.8421923018590989`}]}, \
{{-3.9071666992729934`, -2.2539753896725387`}, 
            Offset[{3, 
             0}, {-3.9071666992729934`, -2.2539753896725387`}]}, \
{{-3.9071666992729934`, -2.2539753896725387`}, 
            Offset[{-3, 
             0}, {-3.9071666992729934`, -2.2539753896725387`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.7563029605395606`, -2.0027566163167188`}, 
            Offset[{3, 
             0}, {-3.7563029605395606`, -2.0027566163167188`}]}, \
{{-3.7563029605395606`, -2.0027566163167188`}, 
            Offset[{-3, 
             0}, {-3.7563029605395606`, -2.0027566163167188`}]}, \
{{-3.7563029605395606`, -2.356016322351946}, 
            Offset[{3, 
             0}, {-3.7563029605395606`, -2.356016322351946}]}, \
{{-3.7563029605395606`, -2.356016322351946}, 
            Offset[{-3, 
             0}, {-3.7563029605395606`, -2.356016322351946}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.6055069407082008`, -1.7371252292206965`}, 
            Offset[{3, 
             0}, {-3.6055069407082008`, -1.7371252292206965`}]}, \
{{-3.6055069407082008`, -1.7371252292206965`}, 
            Offset[{-3, 
             0}, {-3.6055069407082008`, -1.7371252292206965`}]}, \
{{-3.6055069407082008`, -2.0712591417540867`}, 
            Offset[{3, 
             0}, {-3.6055069407082008`, -2.0712591417540867`}]}, \
{{-3.6055069407082008`, -2.0712591417540867`}, 
            Offset[{-3, 
             0}, {-3.6055069407082008`, -2.0712591417540867`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.4564260807134493`, -1.9819361975625527`}, 
            Offset[{3, 
             0}, {-3.4564260807134493`, -1.9819361975625527`}]}, \
{{-3.4564260807134493`, -1.9819361975625527`}, 
            Offset[{-3, 
             0}, {-3.4564260807134493`, -1.9819361975625527`}]}, \
{{-3.4564260807134493`, -2.3154337014558}, 
            Offset[{3, 
             0}, {-3.4564260807134493`, -2.3154337014558}]}, \
{{-3.4564260807134493`, -2.3154337014558}, 
            Offset[{-3, 0}, {-3.4564260807134493`, -2.3154337014558}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.3071524238710044`, -1.9471574433609504`}, 
            Offset[{3, 
             0}, {-3.3071524238710044`, -1.9471574433609504`}]}, \
{{-3.3071524238710044`, -1.9471574433609504`}, 
            Offset[{-3, 
             0}, {-3.3071524238710044`, -1.9471574433609504`}]}, \
{{-3.3071524238710044`, -2.236134018237064}, 
            Offset[{3, 
             0}, {-3.3071524238710044`, -2.236134018237064}]}, \
{{-3.3071524238710044`, -2.236134018237064}, 
            Offset[{-3, 
             0}, {-3.3071524238710044`, -2.236134018237064}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.156690529396256, -1.9442166573865698`}, 
            Offset[{3, 
             0}, {-3.156690529396256, -1.9442166573865698`}]}, \
{{-3.156690529396256, -1.9442166573865698`}, 
            Offset[{-3, 
             0}, {-3.156690529396256, -1.9442166573865698`}]}, \
{{-3.156690529396256, -2.207572101104361}, 
            Offset[{3, 
             0}, {-3.156690529396256, -2.207572101104361}]}, \
{{-3.156690529396256, -2.207572101104361}, 
            Offset[{-3, 0}, {-3.156690529396256, -2.207572101104361}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.0195378319942416`, -1.9019498120885379`}, 
            Offset[{3, 
             0}, {-3.0195378319942416`, -1.9019498120885379`}]}, \
{{-3.0195378319942416`, -1.9019498120885379`}, 
            Offset[{-3, 
             0}, {-3.0195378319942416`, -1.9019498120885379`}]}, \
{{-3.0195378319942416`, -2.242122341649085}, 
            Offset[{3, 
             0}, {-3.0195378319942416`, -2.242122341649085}]}, \
{{-3.0195378319942416`, -2.242122341649085}, 
            Offset[{-3, 
             0}, {-3.0195378319942416`, -2.242122341649085}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.8585261080745212`, -1.6887228990642622`}, 
            Offset[{3, 
             0}, {-2.8585261080745212`, -1.6887228990642622`}]}, \
{{-2.8585261080745212`, -1.6887228990642622`}, 
            Offset[{-3, 
             0}, {-2.8585261080745212`, -1.6887228990642622`}]}, \
{{-2.8585261080745212`, -2.317698131453854}, 
            Offset[{3, 
             0}, {-2.8585261080745212`, -2.317698131453854}]}, \
{{-2.8585261080745212`, -2.317698131453854}, 
            Offset[{-3, 
             0}, {-2.8585261080745212`, -2.317698131453854}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.691382454472379, -1.5907079365347847`}, 
            Offset[{3, 
             0}, {-2.691382454472379, -1.5907079365347847`}]}, \
{{-2.691382454472379, -1.5907079365347847`}, 
            Offset[{-3, 
             0}, {-2.691382454472379, -1.5907079365347847`}]}, \
{{-2.691382454472379, -2.78784802624227}, 
            Offset[{3, 
             0}, {-2.691382454472379, -2.78784802624227}]}, \
{{-2.691382454472379, -2.78784802624227}, 
            Offset[{-3, 0}, {-2.691382454472379, -2.78784802624227}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.5545155316419494`, -1.6431901579754804`}, 
            Offset[{3, 
             0}, {-2.5545155316419494`, -1.6431901579754804`}]}, \
{{-2.5545155316419494`, -1.6431901579754804`}, 
            Offset[{-3, 
             0}, {-2.5545155316419494`, -1.6431901579754804`}]}, \
{{-2.5545155316419494`, -2.7417402803813147`}, 
            Offset[{3, 
             0}, {-2.5545155316419494`, -2.7417402803813147`}]}, \
{{-2.5545155316419494`, -2.7417402803813147`}, 
            Offset[{-3, 
             0}, {-2.5545155316419494`, -2.7417402803813147`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.408966023604327, -1.7619616307175516`}, 
            Offset[{3, 
             0}, {-2.408966023604327, -1.7619616307175516`}]}, \
{{-2.408966023604327, -1.7619616307175516`}, 
            Offset[{-3, 
             0}, {-2.408966023604327, -1.7619616307175516`}]}, \
{{-2.408966023604327, -2.7235790038725742`}, 
            Offset[{3, 
             0}, {-2.408966023604327, -2.7235790038725742`}]}, \
{{-2.408966023604327, -2.7235790038725742`}, 
            Offset[{-3, 
             0}, {-2.408966023604327, -2.7235790038725742`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.2588388882868426`, -1.807850349603532}, 
            Offset[{3, 
             0}, {-2.2588388882868426`, -1.807850349603532}]}, \
{{-2.2588388882868426`, -1.807850349603532}, 
            Offset[{-3, 
             0}, {-2.2588388882868426`, -1.807850349603532}]}, \
{{-2.2588388882868426`, -2.729795390355834}, 
            Offset[{3, 
             0}, {-2.2588388882868426`, -2.729795390355834}]}, \
{{-2.2588388882868426`, -2.729795390355834}, 
            Offset[{-3, 
             0}, {-2.2588388882868426`, -2.729795390355834}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.1096964413451786`, -1.9224515477695563`}, 
            Offset[{3, 
             0}, {-2.1096964413451786`, -1.9224515477695563`}]}, \
{{-2.1096964413451786`, -1.9224515477695563`}, 
            Offset[{-3, 
             0}, {-2.1096964413451786`, -1.9224515477695563`}]}, \
{{-2.1096964413451786`, -2.7535327288177047`}, 
            Offset[{3, 
             0}, {-2.1096964413451786`, -2.7535327288177047`}]}, \
{{-2.1096964413451786`, -2.7535327288177047`}, 
            Offset[{-3, 
             0}, {-2.1096964413451786`, -2.7535327288177047`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.9578947894818906`, -1.9527065682689297`}, 
            Offset[{3, 
             0}, {-1.9578947894818906`, -1.9527065682689297`}]}, \
{{-1.9578947894818906`, -1.9527065682689297`}, 
            Offset[{-3, 
             0}, {-1.9578947894818906`, -1.9527065682689297`}]}, \
{{-1.9578947894818906`, -2.7345648695754594`}, 
            Offset[{3, 
             0}, {-1.9578947894818906`, -2.7345648695754594`}]}, \
{{-1.9578947894818906`, -2.7345648695754594`}, 
            Offset[{-3, 
             0}, {-1.9578947894818906`, -2.7345648695754594`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.8071283500440232`, -2.0539095452111336`}, 
            Offset[{3, 
             0}, {-1.8071283500440232`, -2.0539095452111336`}]}, \
{{-1.8071283500440232`, -2.0539095452111336`}, 
            Offset[{-3, 
             0}, {-1.8071283500440232`, -2.0539095452111336`}]}, \
{{-1.8071283500440232`, -2.7889862251377617`}, 
            Offset[{3, 
             0}, {-1.8071283500440232`, -2.7889862251377617`}]}, \
{{-1.8071283500440232`, -2.7889862251377617`}, 
            Offset[{-3, 
             0}, {-1.8071283500440232`, -2.7889862251377617`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.65618364739931, -2.1261626161341476`}, 
            Offset[{3, 
             0}, {-1.65618364739931, -2.1261626161341476`}]}, \
{{-1.65618364739931, -2.1261626161341476`}, 
            Offset[{-3, 
             0}, {-1.65618364739931, -2.1261626161341476`}]}, \
{{-1.65618364739931, -2.81505323267394}, 
            Offset[{3, 
             0}, {-1.65618364739931, -2.81505323267394}]}, \
{{-1.65618364739931, -2.81505323267394}, 
            Offset[{-3, 0}, {-1.65618364739931, -2.81505323267394}]}}], {{{1.,
           0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.5040228008910033`, -2.2211862249783216`}, 
            Offset[{3, 
             0}, {-1.5040228008910033`, -2.2211862249783216`}]}, \
{{-1.5040228008910033`, -2.2211862249783216`}, 
            Offset[{-3, 
             0}, {-1.5040228008910033`, -2.2211862249783216`}]}, \
{{-1.5040228008910033`, -2.875105173039695}, 
            Offset[{3, 
             0}, {-1.5040228008910033`, -2.875105173039695}]}, \
{{-1.5040228008910033`, -2.875105173039695}, 
            Offset[{-3, 
             0}, {-1.5040228008910033`, -2.875105173039695}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.3539296288670801`, -2.326001350065366}, 
            Offset[{3, 
             0}, {-1.3539296288670801`, -2.326001350065366}]}, \
{{-1.3539296288670801`, -2.326001350065366}, 
            Offset[{-3, 
             0}, {-1.3539296288670801`, -2.326001350065366}]}, \
{{-1.3539296288670801`, -2.956534168031409}, 
            Offset[{3, 
             0}, {-1.3539296288670801`, -2.956534168031409}]}, \
{{-1.3539296288670801`, -2.956534168031409}, 
            Offset[{-3, 
             0}, {-1.3539296288670801`, -2.956534168031409}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.2055237319284868`, -2.4020969056151844`}, 
            Offset[{3, 
             0}, {-1.2055237319284868`, -2.4020969056151844`}]}, \
{{-1.2055237319284868`, -2.4020969056151844`}, 
            Offset[{-3, 
             0}, {-1.2055237319284868`, -2.4020969056151844`}]}, \
{{-1.2055237319284868`, -3.0030836819866935`}, 
            Offset[{3, 
             0}, {-1.2055237319284868`, -3.0030836819866935`}]}, \
{{-1.2055237319284868`, -3.0030836819866935`}, 
            Offset[{-3, 
             0}, {-1.2055237319284868`, -3.0030836819866935`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}}}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJwBsQFO/iFib1JlAgAAABoAAAACAAAAPgEN6BvZE8BK3Cx95Nj3v5zekUvQ
PxPAdReuZuzB978SA/vTLqYSwEiJqOHrwfe/tQ9PCS8LEsAw6sul5tf+vw/h
8gBwbxHA8W24XBCn+L8e+hnTN9MQwNeO6RoxSP2/gHn/FJs5EMBpG6KJCEf9
v6QuS53gQQ/ApT2IyHliAMBIFQuR6AwOwEAWWSxibwHA673eBRTYDMBLeZ85
knf+v1GljbfCpgvABGUcvIEwAcAETntUDHUKwE3MxMGwuwDAfMza9uZACcDZ
eSaDbpsAwJ+Za3MDKAjA/kSSpoeTAMCwiafvQt4GwOVTEDyTBgDAiOU3hvOH
BcA+VZ8spIMBwLY1zNalbwTA1uhvNCuKAcAscoT6j0UDwFPGaZAx8QHA+f+A
HxoSAsA41teajCYCwGCFIIeo4ADAxDXiODW0AsAeVp18iVP/v/IQdBXEvwLA
+tCxav/p/L9HV54RIF8DwCEAnGy6f/q/M25kFs7DA8AsPmQ2ehD4v3d+VTaa
YgTAyBxRHbKp9b97vKj9UCEFwJ/0skDTSfO/guXyqOeeBcDOr9El
      "]]}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-6.907755278982122, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["\"Slope\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) \
[\\!\\(\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], 
      TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {{{
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{367.456787109375, Automatic},
  LabelStyle->{FontSize -> 14, 
    GrayLevel[0]},
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{-6.907755278982137, 0.}, {-6., 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], Automatic}]], "Output",
 CellChangeTimes->{
  3.852797345983632*^9, {3.852797675781699*^9, 3.852797695678535*^9}, 
   3.852797816698617*^9, 3.8527979046846867`*^9, {3.852797989212296*^9, 
   3.852798038960855*^9}, 3.852798522749322*^9, {3.852798578042531*^9, 
   3.852798621271277*^9}, 3.8527986774171886`*^9, {3.852798746320681*^9, 
   3.8527987989025307`*^9}, 3.85279883319804*^9, {3.8527988977815037`*^9, 
   3.852798988466496*^9}, {3.852799066571772*^9, 3.852799085595117*^9}, 
   3.852799371236321*^9, {3.852801936937695*^9, 3.852801973543593*^9}, {
   3.852802104655958*^9, 3.852802119561268*^9}, 3.852862500410799*^9, 
   3.852862533883133*^9, {3.852862701607958*^9, 3.852862752832765*^9}, 
   3.852862800589758*^9, {3.852862841572309*^9, 3.85286287853053*^9}, {
   3.852862961040063*^9, 3.852862987162868*^9}, {3.852863041784163*^9, 
   3.852863052517976*^9}, {3.85286851855713*^9, 3.852868563456098*^9}, 
   3.8528686112469378`*^9, {3.852868645635429*^9, 3.852868681292514*^9}, {
   3.852868719950995*^9, 3.852868738834832*^9}, 3.852868916826046*^9, {
   3.852868968202001*^9, 3.85286898265627*^9}, 3.852870678975832*^9, {
   3.8528711007779913`*^9, 3.852871118216545*^9}, 3.85287115355669*^9, 
   3.8528716206367083`*^9, 3.852874084668347*^9, 3.853381370706914*^9, 
   3.853381477907443*^9, 3.853382039594591*^9, 3.85338235753389*^9, 
   3.853402538913465*^9, 3.853403585786399*^9, 3.853405167845274*^9, 
   3.853405199586698*^9, 3.8534052376911182`*^9, 3.853405419430604*^9, {
   3.853409759182901*^9, 3.85340977227461*^9}, 3.8534101965227337`*^9, 
   3.853410249470071*^9, {3.853410575932642*^9, 3.853410598926773*^9}, 
   3.853469099635906*^9, 3.853469309131391*^9, 3.8534962859629583`*^9, 
   3.853499637160716*^9, 3.853817851525353*^9, 3.853818263087407*^9, 
   3.853824688277567*^9, 3.853824875156226*^9, 3.853833080309764*^9, 
   3.8538364568591433`*^9, 3.8538367165690203`*^9, 3.853838543473041*^9, 
   3.854072558698359*^9, 3.854091679143179*^9, 3.854098465796619*^9, 
   3.854420763080948*^9, 3.8544215348281403`*^9, 3.854423713611958*^9, 
   3.860120822653838*^9, 3.860120994984702*^9, 3.860121301461205*^9, 
   3.861765157588767*^9, {3.8617652327352104`*^9, 3.861765246883433*^9}, {
   3.8617654618721933`*^9, 3.861765495117054*^9}, 3.8617669010806527`*^9, {
   3.8617669653893194`*^9, 3.8617669711987777`*^9}, {3.8617681636139946`*^9, 
   3.861768172620324*^9}, {3.8617682638779945`*^9, 3.861768268816891*^9}, 
   3.861941031402981*^9, 3.8619503251086683`*^9, 3.8636862757494583`*^9, 
   3.863687240140381*^9, 3.885975752049604*^9, 3.885976865574806*^9, 
   3.885976952011711*^9, 3.8859772099410114`*^9, 3.8859772799657326`*^9, 
   3.8859777404306726`*^9, 3.885977787111581*^9, 3.8859795103782063`*^9, 
   3.885980164747009*^9, 3.885980479715824*^9, 3.8859806419052787`*^9, 
   3.8859808116886177`*^9, 3.886063156226128*^9, 3.8860712486314845`*^9, 
   3.888310980288575*^9, 3.888311308510944*^9, 3.889060346347356*^9, 
   3.889064571126178*^9, 3.8890819159217157`*^9, 3.889082752421399*^9, 
   3.889084482404039*^9, 3.8895043087134247`*^9, 3.8895154534729757`*^9, 
   3.8896688023607087`*^9, 3.8896724468191605`*^9, {3.889676431056512*^9, 
   3.8896764550519114`*^9}, {3.8896765019285583`*^9, 3.8896765617701*^9}, {
   3.8896766223493395`*^9, 3.889676630450638*^9}, 3.8896767650691853`*^9, 
   3.8896768162718754`*^9, {3.8896768629395857`*^9, 3.8896768889532757`*^9}, 
   3.89020392289333*^9, 3.890205948951085*^9, 3.890210264027658*^9, 
   3.8902168394329166`*^9, 3.8902168818527*^9, 3.8902172179744573`*^9, 
   3.8902178258568845`*^9, 3.8909818360454464`*^9, 3.8909822668066454`*^9, 
   3.890982759573165*^9, 3.891416145956769*^9, 3.8914268911207743`*^9, 
   3.8926186523763256`*^9, 3.8926186857701473`*^9, 3.892618917765296*^9, 
   3.8926285323692555`*^9, 3.902311032012074*^9, 3.9023111094981766`*^9, 
   3.90231139390695*^9, {3.902312359119079*^9, 3.9023123778792515`*^9}},
 CellLabel->
  "Out[1730]=",ExpressionUUID->"4b77bf26-5248-4c14-812a-fa8fb9704927"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2022-08_\
new_data\\\\Analysis\\\\Full form factor fit\\\\LH-ESRF-C16 - volume (not \
corrupted)\\\\Slopes.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.852797345983632*^9, {3.852797675781699*^9, 3.852797695678535*^9}, 
   3.852797816698617*^9, 3.8527979046846867`*^9, {3.852797989212296*^9, 
   3.852798038960855*^9}, 3.852798522749322*^9, {3.852798578042531*^9, 
   3.852798621271277*^9}, 3.8527986774171886`*^9, {3.852798746320681*^9, 
   3.8527987989025307`*^9}, 3.85279883319804*^9, {3.8527988977815037`*^9, 
   3.852798988466496*^9}, {3.852799066571772*^9, 3.852799085595117*^9}, 
   3.852799371236321*^9, {3.852801936937695*^9, 3.852801973543593*^9}, {
   3.852802104655958*^9, 3.852802119561268*^9}, 3.852862500410799*^9, 
   3.852862533883133*^9, {3.852862701607958*^9, 3.852862752832765*^9}, 
   3.852862800589758*^9, {3.852862841572309*^9, 3.85286287853053*^9}, {
   3.852862961040063*^9, 3.852862987162868*^9}, {3.852863041784163*^9, 
   3.852863052517976*^9}, {3.85286851855713*^9, 3.852868563456098*^9}, 
   3.8528686112469378`*^9, {3.852868645635429*^9, 3.852868681292514*^9}, {
   3.852868719950995*^9, 3.852868738834832*^9}, 3.852868916826046*^9, {
   3.852868968202001*^9, 3.85286898265627*^9}, 3.852870678975832*^9, {
   3.8528711007779913`*^9, 3.852871118216545*^9}, 3.85287115355669*^9, 
   3.8528716206367083`*^9, 3.852874084668347*^9, 3.853381370706914*^9, 
   3.853381477907443*^9, 3.853382039594591*^9, 3.85338235753389*^9, 
   3.853402538913465*^9, 3.853403585786399*^9, 3.853405167845274*^9, 
   3.853405199586698*^9, 3.8534052376911182`*^9, 3.853405419430604*^9, {
   3.853409759182901*^9, 3.85340977227461*^9}, 3.8534101965227337`*^9, 
   3.853410249470071*^9, {3.853410575932642*^9, 3.853410598926773*^9}, 
   3.853469099635906*^9, 3.853469309131391*^9, 3.8534962859629583`*^9, 
   3.853499637160716*^9, 3.853817851525353*^9, 3.853818263087407*^9, 
   3.853824688277567*^9, 3.853824875156226*^9, 3.853833080309764*^9, 
   3.8538364568591433`*^9, 3.8538367165690203`*^9, 3.853838543473041*^9, 
   3.854072558698359*^9, 3.854091679143179*^9, 3.854098465796619*^9, 
   3.854420763080948*^9, 3.8544215348281403`*^9, 3.854423713611958*^9, 
   3.860120822653838*^9, 3.860120994984702*^9, 3.860121301461205*^9, 
   3.861765157588767*^9, {3.8617652327352104`*^9, 3.861765246883433*^9}, {
   3.8617654618721933`*^9, 3.861765495117054*^9}, 3.8617669010806527`*^9, {
   3.8617669653893194`*^9, 3.8617669711987777`*^9}, {3.8617681636139946`*^9, 
   3.861768172620324*^9}, {3.8617682638779945`*^9, 3.861768268816891*^9}, 
   3.861941031402981*^9, 3.8619503251086683`*^9, 3.8636862757494583`*^9, 
   3.863687240140381*^9, 3.885975752049604*^9, 3.885976865574806*^9, 
   3.885976952011711*^9, 3.8859772099410114`*^9, 3.8859772799657326`*^9, 
   3.8859777404306726`*^9, 3.885977787111581*^9, 3.8859795103782063`*^9, 
   3.885980164747009*^9, 3.885980479715824*^9, 3.8859806419052787`*^9, 
   3.8859808116886177`*^9, 3.886063156226128*^9, 3.8860712486314845`*^9, 
   3.888310980288575*^9, 3.888311308510944*^9, 3.889060346347356*^9, 
   3.889064571126178*^9, 3.8890819159217157`*^9, 3.889082752421399*^9, 
   3.889084482404039*^9, 3.8895043087134247`*^9, 3.8895154534729757`*^9, 
   3.8896688023607087`*^9, 3.8896724468191605`*^9, {3.889676431056512*^9, 
   3.8896764550519114`*^9}, {3.8896765019285583`*^9, 3.8896765617701*^9}, {
   3.8896766223493395`*^9, 3.889676630450638*^9}, 3.8896767650691853`*^9, 
   3.8896768162718754`*^9, {3.8896768629395857`*^9, 3.8896768889532757`*^9}, 
   3.89020392289333*^9, 3.890205948951085*^9, 3.890210264027658*^9, 
   3.8902168394329166`*^9, 3.8902168818527*^9, 3.8902172179744573`*^9, 
   3.8902178258568845`*^9, 3.8909818360454464`*^9, 3.8909822668066454`*^9, 
   3.890982759573165*^9, 3.891416145956769*^9, 3.8914268911207743`*^9, 
   3.8926186523763256`*^9, 3.8926186857701473`*^9, 3.892618917765296*^9, 
   3.8926285323692555`*^9, 3.902311032012074*^9, 3.9023111094981766`*^9, 
   3.90231139390695*^9, {3.902312359119079*^9, 3.9023123782586894`*^9}},
 CellLabel->
  "Out[1731]=",ExpressionUUID->"13704aff-cd1d-469c-a8ed-d2d589f43392"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.006998772397075992`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.49", "0.31"},
       "Around"],
      Around[-1.4904522790582342`, 0.307070657457283]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.008128994664196353`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.48", "0.27"},
       "Around"],
      Around[-1.484844590276649, 0.26513589514948493`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.009444827802205638`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.48", "0.25"},
       "Around"],
      Around[-1.484844094732198, 0.24698821342362098`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.010988328477601686`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.93", "0.25"},
       "Around"],
      Around[-1.9277101971080235`, 0.25429033262757167`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.012793402153201985`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.54", "0.21"},
       "Around"],
      Around[-1.5407870885745718`, 0.20884309530386852`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.014901883844487769`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.83", "0.19"},
       "Around"],
      Around[-1.8301249552977674`, 0.18848630935129818`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.01731372648802987`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.83", "0.22"},
       "Around"],
      Around[-1.8298421264932705`, 0.21558137210650413`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.020097362342427434`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.05", "0.21"},
       "Around"],
      Around[-2.048083845765819, 0.20589154390672004`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.023369980600379647`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.18", "0.18"},
       "Around"],
      Around[-2.1793864693343323`, 0.17662985301761358`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.02717366588337089`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.90", "0.17"},
       "Around"],
      Around[-1.9041921854873916`, 0.16706695626669504`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.03154229041494413`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.15", "0.17"},
       "Around"],
      Around[-2.1486849495091764`, 0.16674875194662375`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.03662030452823401`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.09", "0.14"},
       "Around"],
      Around[-2.0916457307990073`, 0.14448828743805683`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.042566380415968816`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.08", "0.13"},
       "Around"],
      Around[-2.0758943792454656`, 0.13167772185889579`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.04882377793653714`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.07", "0.17"},
       "Around"],
      Around[-2.0720360768688115`, 0.1700862647802737]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.05735323046348458`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.00", "0.31"},
       "Around"],
      Around[-2.0032105152590582`, 0.314487616194796]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.06778716190001575`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.2", "0.6"},
       "Around"],
      Around[-2.1892779813885275`, 0.5985700448537428]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.07772988061443384`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.2", "0.5"},
       "Around"],
      Around[-2.1924652191783975`, 0.5492750612029172]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.08990820949444596`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.2", "0.5"},
       "Around"],
      Around[-2.242770317295063, 0.48080868657751125`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.10447171769375985`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.3", "0.5"},
       "Around"],
      Around[-2.268822869979683, 0.4609725203761509]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.12127477485386011`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.3", "0.4"},
       "Around"],
      Around[-2.3379921382936306`, 0.4155405905240743]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.14115526990550042`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.3", "0.4"},
       "Around"],
      Around[-2.3436357189221946`, 0.3909291506532648]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.16412476962038627`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.4", "0.4"},
       "Around"],
      Around[-2.4214478851744476`, 0.36753833996331403`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.1908660038999079`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.47", "0.34"},
       "Around"],
      Around[-2.4706079244040438`, 0.3444453082698963]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.2222343549723674`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.55", "0.33"},
       "Around"],
      Around[-2.5481456990090083`, 0.32695947403068676`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.2582235416067372`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.64", "0.32"},
       "Around"],
      Around[-2.6412677590483873`, 0.3152664089830216]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.2995350823392431`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.70", "0.30"},
       "Around"],
      Around[-2.702590293800939, 0.3004933881857547]]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.852797345983632*^9, {3.852797675781699*^9, 3.852797695678535*^9}, 
   3.852797816698617*^9, 3.8527979046846867`*^9, {3.852797989212296*^9, 
   3.852798038960855*^9}, 3.852798522749322*^9, {3.852798578042531*^9, 
   3.852798621271277*^9}, 3.8527986774171886`*^9, {3.852798746320681*^9, 
   3.8527987989025307`*^9}, 3.85279883319804*^9, {3.8527988977815037`*^9, 
   3.852798988466496*^9}, {3.852799066571772*^9, 3.852799085595117*^9}, 
   3.852799371236321*^9, {3.852801936937695*^9, 3.852801973543593*^9}, {
   3.852802104655958*^9, 3.852802119561268*^9}, 3.852862500410799*^9, 
   3.852862533883133*^9, {3.852862701607958*^9, 3.852862752832765*^9}, 
   3.852862800589758*^9, {3.852862841572309*^9, 3.85286287853053*^9}, {
   3.852862961040063*^9, 3.852862987162868*^9}, {3.852863041784163*^9, 
   3.852863052517976*^9}, {3.85286851855713*^9, 3.852868563456098*^9}, 
   3.8528686112469378`*^9, {3.852868645635429*^9, 3.852868681292514*^9}, {
   3.852868719950995*^9, 3.852868738834832*^9}, 3.852868916826046*^9, {
   3.852868968202001*^9, 3.85286898265627*^9}, 3.852870678975832*^9, {
   3.8528711007779913`*^9, 3.852871118216545*^9}, 3.85287115355669*^9, 
   3.8528716206367083`*^9, 3.852874084668347*^9, 3.853381370706914*^9, 
   3.853381477907443*^9, 3.853382039594591*^9, 3.85338235753389*^9, 
   3.853402538913465*^9, 3.853403585786399*^9, 3.853405167845274*^9, 
   3.853405199586698*^9, 3.8534052376911182`*^9, 3.853405419430604*^9, {
   3.853409759182901*^9, 3.85340977227461*^9}, 3.8534101965227337`*^9, 
   3.853410249470071*^9, {3.853410575932642*^9, 3.853410598926773*^9}, 
   3.853469099635906*^9, 3.853469309131391*^9, 3.8534962859629583`*^9, 
   3.853499637160716*^9, 3.853817851525353*^9, 3.853818263087407*^9, 
   3.853824688277567*^9, 3.853824875156226*^9, 3.853833080309764*^9, 
   3.8538364568591433`*^9, 3.8538367165690203`*^9, 3.853838543473041*^9, 
   3.854072558698359*^9, 3.854091679143179*^9, 3.854098465796619*^9, 
   3.854420763080948*^9, 3.8544215348281403`*^9, 3.854423713611958*^9, 
   3.860120822653838*^9, 3.860120994984702*^9, 3.860121301461205*^9, 
   3.861765157588767*^9, {3.8617652327352104`*^9, 3.861765246883433*^9}, {
   3.8617654618721933`*^9, 3.861765495117054*^9}, 3.8617669010806527`*^9, {
   3.8617669653893194`*^9, 3.8617669711987777`*^9}, {3.8617681636139946`*^9, 
   3.861768172620324*^9}, {3.8617682638779945`*^9, 3.861768268816891*^9}, 
   3.861941031402981*^9, 3.8619503251086683`*^9, 3.8636862757494583`*^9, 
   3.863687240140381*^9, 3.885975752049604*^9, 3.885976865574806*^9, 
   3.885976952011711*^9, 3.8859772099410114`*^9, 3.8859772799657326`*^9, 
   3.8859777404306726`*^9, 3.885977787111581*^9, 3.8859795103782063`*^9, 
   3.885980164747009*^9, 3.885980479715824*^9, 3.8859806419052787`*^9, 
   3.8859808116886177`*^9, 3.886063156226128*^9, 3.8860712486314845`*^9, 
   3.888310980288575*^9, 3.888311308510944*^9, 3.889060346347356*^9, 
   3.889064571126178*^9, 3.8890819159217157`*^9, 3.889082752421399*^9, 
   3.889084482404039*^9, 3.8895043087134247`*^9, 3.8895154534729757`*^9, 
   3.8896688023607087`*^9, 3.8896724468191605`*^9, {3.889676431056512*^9, 
   3.8896764550519114`*^9}, {3.8896765019285583`*^9, 3.8896765617701*^9}, {
   3.8896766223493395`*^9, 3.889676630450638*^9}, 3.8896767650691853`*^9, 
   3.8896768162718754`*^9, {3.8896768629395857`*^9, 3.8896768889532757`*^9}, 
   3.89020392289333*^9, 3.890205948951085*^9, 3.890210264027658*^9, 
   3.8902168394329166`*^9, 3.8902168818527*^9, 3.8902172179744573`*^9, 
   3.8902178258568845`*^9, 3.8909818360454464`*^9, 3.8909822668066454`*^9, 
   3.890982759573165*^9, 3.891416145956769*^9, 3.8914268911207743`*^9, 
   3.8926186523763256`*^9, 3.8926186857701473`*^9, 3.892618917765296*^9, 
   3.8926285323692555`*^9, 3.902311032012074*^9, 3.9023111094981766`*^9, 
   3.90231139390695*^9, {3.902312359119079*^9, 3.902312378284948*^9}},
 CellLabel->
  "Out[1732]=",ExpressionUUID->"564dadee-9ec3-415d-b3c6-f1a6b4ff81e8"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2022-08_\
new_data\\\\Analysis\\\\Full form factor fit\\\\LH-ESRF-C16 - volume (not \
corrupted)\\\\Sample playground LH-ESRF-C16 NEW SAXS slopes.csv\"\>"], \
"Output",
 CellChangeTimes->{
  3.852797345983632*^9, {3.852797675781699*^9, 3.852797695678535*^9}, 
   3.852797816698617*^9, 3.8527979046846867`*^9, {3.852797989212296*^9, 
   3.852798038960855*^9}, 3.852798522749322*^9, {3.852798578042531*^9, 
   3.852798621271277*^9}, 3.8527986774171886`*^9, {3.852798746320681*^9, 
   3.8527987989025307`*^9}, 3.85279883319804*^9, {3.8527988977815037`*^9, 
   3.852798988466496*^9}, {3.852799066571772*^9, 3.852799085595117*^9}, 
   3.852799371236321*^9, {3.852801936937695*^9, 3.852801973543593*^9}, {
   3.852802104655958*^9, 3.852802119561268*^9}, 3.852862500410799*^9, 
   3.852862533883133*^9, {3.852862701607958*^9, 3.852862752832765*^9}, 
   3.852862800589758*^9, {3.852862841572309*^9, 3.85286287853053*^9}, {
   3.852862961040063*^9, 3.852862987162868*^9}, {3.852863041784163*^9, 
   3.852863052517976*^9}, {3.85286851855713*^9, 3.852868563456098*^9}, 
   3.8528686112469378`*^9, {3.852868645635429*^9, 3.852868681292514*^9}, {
   3.852868719950995*^9, 3.852868738834832*^9}, 3.852868916826046*^9, {
   3.852868968202001*^9, 3.85286898265627*^9}, 3.852870678975832*^9, {
   3.8528711007779913`*^9, 3.852871118216545*^9}, 3.85287115355669*^9, 
   3.8528716206367083`*^9, 3.852874084668347*^9, 3.853381370706914*^9, 
   3.853381477907443*^9, 3.853382039594591*^9, 3.85338235753389*^9, 
   3.853402538913465*^9, 3.853403585786399*^9, 3.853405167845274*^9, 
   3.853405199586698*^9, 3.8534052376911182`*^9, 3.853405419430604*^9, {
   3.853409759182901*^9, 3.85340977227461*^9}, 3.8534101965227337`*^9, 
   3.853410249470071*^9, {3.853410575932642*^9, 3.853410598926773*^9}, 
   3.853469099635906*^9, 3.853469309131391*^9, 3.8534962859629583`*^9, 
   3.853499637160716*^9, 3.853817851525353*^9, 3.853818263087407*^9, 
   3.853824688277567*^9, 3.853824875156226*^9, 3.853833080309764*^9, 
   3.8538364568591433`*^9, 3.8538367165690203`*^9, 3.853838543473041*^9, 
   3.854072558698359*^9, 3.854091679143179*^9, 3.854098465796619*^9, 
   3.854420763080948*^9, 3.8544215348281403`*^9, 3.854423713611958*^9, 
   3.860120822653838*^9, 3.860120994984702*^9, 3.860121301461205*^9, 
   3.861765157588767*^9, {3.8617652327352104`*^9, 3.861765246883433*^9}, {
   3.8617654618721933`*^9, 3.861765495117054*^9}, 3.8617669010806527`*^9, {
   3.8617669653893194`*^9, 3.8617669711987777`*^9}, {3.8617681636139946`*^9, 
   3.861768172620324*^9}, {3.8617682638779945`*^9, 3.861768268816891*^9}, 
   3.861941031402981*^9, 3.8619503251086683`*^9, 3.8636862757494583`*^9, 
   3.863687240140381*^9, 3.885975752049604*^9, 3.885976865574806*^9, 
   3.885976952011711*^9, 3.8859772099410114`*^9, 3.8859772799657326`*^9, 
   3.8859777404306726`*^9, 3.885977787111581*^9, 3.8859795103782063`*^9, 
   3.885980164747009*^9, 3.885980479715824*^9, 3.8859806419052787`*^9, 
   3.8859808116886177`*^9, 3.886063156226128*^9, 3.8860712486314845`*^9, 
   3.888310980288575*^9, 3.888311308510944*^9, 3.889060346347356*^9, 
   3.889064571126178*^9, 3.8890819159217157`*^9, 3.889082752421399*^9, 
   3.889084482404039*^9, 3.8895043087134247`*^9, 3.8895154534729757`*^9, 
   3.8896688023607087`*^9, 3.8896724468191605`*^9, {3.889676431056512*^9, 
   3.8896764550519114`*^9}, {3.8896765019285583`*^9, 3.8896765617701*^9}, {
   3.8896766223493395`*^9, 3.889676630450638*^9}, 3.8896767650691853`*^9, 
   3.8896768162718754`*^9, {3.8896768629395857`*^9, 3.8896768889532757`*^9}, 
   3.89020392289333*^9, 3.890205948951085*^9, 3.890210264027658*^9, 
   3.8902168394329166`*^9, 3.8902168818527*^9, 3.8902172179744573`*^9, 
   3.8902178258568845`*^9, 3.8909818360454464`*^9, 3.8909822668066454`*^9, 
   3.890982759573165*^9, 3.891416145956769*^9, 3.8914268911207743`*^9, 
   3.8926186523763256`*^9, 3.8926186857701473`*^9, 3.892618917765296*^9, 
   3.8926285323692555`*^9, 3.902311032012074*^9, 3.9023111094981766`*^9, 
   3.90231139390695*^9, {3.902312359119079*^9, 3.9023123783102913`*^9}},
 CellLabel->
  "Out[1734]=",ExpressionUUID->"dd6ceacc-1060-4a25-855d-ca10de4d4edb"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2022-08_\
new_data\\\\Analysis\\\\Full form factor fit\\\\LH-ESRF-C16 - volume (not \
corrupted)\\\\Sample playground LH-ESRF-C16 NEW.nb\"\>"], "Output",
 CellChangeTimes->{
  3.852797345983632*^9, {3.852797675781699*^9, 3.852797695678535*^9}, 
   3.852797816698617*^9, 3.8527979046846867`*^9, {3.852797989212296*^9, 
   3.852798038960855*^9}, 3.852798522749322*^9, {3.852798578042531*^9, 
   3.852798621271277*^9}, 3.8527986774171886`*^9, {3.852798746320681*^9, 
   3.8527987989025307`*^9}, 3.85279883319804*^9, {3.8527988977815037`*^9, 
   3.852798988466496*^9}, {3.852799066571772*^9, 3.852799085595117*^9}, 
   3.852799371236321*^9, {3.852801936937695*^9, 3.852801973543593*^9}, {
   3.852802104655958*^9, 3.852802119561268*^9}, 3.852862500410799*^9, 
   3.852862533883133*^9, {3.852862701607958*^9, 3.852862752832765*^9}, 
   3.852862800589758*^9, {3.852862841572309*^9, 3.85286287853053*^9}, {
   3.852862961040063*^9, 3.852862987162868*^9}, {3.852863041784163*^9, 
   3.852863052517976*^9}, {3.85286851855713*^9, 3.852868563456098*^9}, 
   3.8528686112469378`*^9, {3.852868645635429*^9, 3.852868681292514*^9}, {
   3.852868719950995*^9, 3.852868738834832*^9}, 3.852868916826046*^9, {
   3.852868968202001*^9, 3.85286898265627*^9}, 3.852870678975832*^9, {
   3.8528711007779913`*^9, 3.852871118216545*^9}, 3.85287115355669*^9, 
   3.8528716206367083`*^9, 3.852874084668347*^9, 3.853381370706914*^9, 
   3.853381477907443*^9, 3.853382039594591*^9, 3.85338235753389*^9, 
   3.853402538913465*^9, 3.853403585786399*^9, 3.853405167845274*^9, 
   3.853405199586698*^9, 3.8534052376911182`*^9, 3.853405419430604*^9, {
   3.853409759182901*^9, 3.85340977227461*^9}, 3.8534101965227337`*^9, 
   3.853410249470071*^9, {3.853410575932642*^9, 3.853410598926773*^9}, 
   3.853469099635906*^9, 3.853469309131391*^9, 3.8534962859629583`*^9, 
   3.853499637160716*^9, 3.853817851525353*^9, 3.853818263087407*^9, 
   3.853824688277567*^9, 3.853824875156226*^9, 3.853833080309764*^9, 
   3.8538364568591433`*^9, 3.8538367165690203`*^9, 3.853838543473041*^9, 
   3.854072558698359*^9, 3.854091679143179*^9, 3.854098465796619*^9, 
   3.854420763080948*^9, 3.8544215348281403`*^9, 3.854423713611958*^9, 
   3.860120822653838*^9, 3.860120994984702*^9, 3.860121301461205*^9, 
   3.861765157588767*^9, {3.8617652327352104`*^9, 3.861765246883433*^9}, {
   3.8617654618721933`*^9, 3.861765495117054*^9}, 3.8617669010806527`*^9, {
   3.8617669653893194`*^9, 3.8617669711987777`*^9}, {3.8617681636139946`*^9, 
   3.861768172620324*^9}, {3.8617682638779945`*^9, 3.861768268816891*^9}, 
   3.861941031402981*^9, 3.8619503251086683`*^9, 3.8636862757494583`*^9, 
   3.863687240140381*^9, 3.885975752049604*^9, 3.885976865574806*^9, 
   3.885976952011711*^9, 3.8859772099410114`*^9, 3.8859772799657326`*^9, 
   3.8859777404306726`*^9, 3.885977787111581*^9, 3.8859795103782063`*^9, 
   3.885980164747009*^9, 3.885980479715824*^9, 3.8859806419052787`*^9, 
   3.8859808116886177`*^9, 3.886063156226128*^9, 3.8860712486314845`*^9, 
   3.888310980288575*^9, 3.888311308510944*^9, 3.889060346347356*^9, 
   3.889064571126178*^9, 3.8890819159217157`*^9, 3.889082752421399*^9, 
   3.889084482404039*^9, 3.8895043087134247`*^9, 3.8895154534729757`*^9, 
   3.8896688023607087`*^9, 3.8896724468191605`*^9, {3.889676431056512*^9, 
   3.8896764550519114`*^9}, {3.8896765019285583`*^9, 3.8896765617701*^9}, {
   3.8896766223493395`*^9, 3.889676630450638*^9}, 3.8896767650691853`*^9, 
   3.8896768162718754`*^9, {3.8896768629395857`*^9, 3.8896768889532757`*^9}, 
   3.89020392289333*^9, 3.890205948951085*^9, 3.890210264027658*^9, 
   3.8902168394329166`*^9, 3.8902168818527*^9, 3.8902172179744573`*^9, 
   3.8902178258568845`*^9, 3.8909818360454464`*^9, 3.8909822668066454`*^9, 
   3.890982759573165*^9, 3.891416145956769*^9, 3.8914268911207743`*^9, 
   3.8926186523763256`*^9, 3.8926186857701473`*^9, 3.892618917765296*^9, 
   3.8926285323692555`*^9, 3.902311032012074*^9, 3.9023111094981766`*^9, 
   3.90231139390695*^9, {3.902312359119079*^9, 3.9023123783287563`*^9}},
 CellLabel->
  "Out[1735]=",ExpressionUUID->"484226f1-a046-4bbb-af55-2a58fa13a5ef"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fitting slopes using L + R (thickness + radius)", "Subsubsection",
 CellChangeTimes->{{3.8890831159415197`*^9, 3.889083129907494*^9}, {
  3.8895043397252035`*^9, 
  3.889504346042064*^9}},ExpressionUUID->"c264222d-eedd-4632-bf2a-\
25682c9a5ec9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fitSlopeLRResult", "=", 
  RowBox[{"fitSlopeLR", "[", 
   RowBox[{
   "datamerged", ",", " ", "2.6", ",", " ", "0.5", ",", " ", "6", ",", " ", 
    "0.5"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8890831508560247`*^9, 3.889083186178582*^9}, {
  3.889083221328817*^9, 3.889083280853166*^9}, {3.890210231443339*^9, 
  3.8902102343651667`*^9}},
 CellLabel->
  "In[1743]:=",ExpressionUUID->"245caa09-fb84-4947-ab47-dd7c0b5b4707"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.3599912341044109`"}], 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "1.9261364922640287`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.910243414458993`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.607379489707849`"}],
  SequenceForm[
  "\[Mu]l = ", -0.3599912341044109, " \[Sigma]l = ", 1.9261364922640287`, 
   " \[Mu]r = ", 5.910243414458993 " \[Sigma]r = ", 0.607379489707849],
  Editable->False]], "Print",
 CellChangeTimes->{3.8914909506894035`*^9, 3.8926187077718725`*^9, 
  3.8926190298167424`*^9, 3.892628549399665*^9, 3.90231112507862*^9, 
  3.9023114117913237`*^9, 3.9023124176465073`*^9},
 CellLabel->
  "During evaluation of \
In[1743]:=",ExpressionUUID->"f5cf4654-0361-4b1e-bf4e-ae97305a9089"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.036907537743381125`"}], 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "1.0794429132865944`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.808140492268532`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.7071538238418109`"}],
  SequenceForm[
  "\[Mu]l = ", -0.036907537743381125`, " \[Sigma]l = ", 1.0794429132865944`, 
   " \[Mu]r = ", 5.808140492268532 " \[Sigma]r = ", 0.7071538238418109],
  Editable->False]], "Print",
 CellChangeTimes->{3.8914909506894035`*^9, 3.8926187077718725`*^9, 
  3.8926190298167424`*^9, 3.892628549399665*^9, 3.90231112507862*^9, 
  3.9023114117913237`*^9, 3.902312419710949*^9},
 CellLabel->
  "During evaluation of \
In[1743]:=",ExpressionUUID->"7525d324-35f4-4f8d-969c-c1d3b0512dff"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.1773442305666526`"}], 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "1.365224451352997`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.685335055800223`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.7311093975907035`"}],
  SequenceForm[
  "\[Mu]l = ", -0.1773442305666526, " \[Sigma]l = ", 1.365224451352997, 
   " \[Mu]r = ", 5.685335055800223 " \[Sigma]r = ", 0.7311093975907035],
  Editable->False]], "Print",
 CellChangeTimes->{3.8914909506894035`*^9, 3.8926187077718725`*^9, 
  3.8926190298167424`*^9, 3.892628549399665*^9, 3.90231112507862*^9, 
  3.9023114117913237`*^9, 3.902312421738593*^9},
 CellLabel->
  "During evaluation of \
In[1743]:=",ExpressionUUID->"7fdd5967-6319-4e87-8362-243c91637e63"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.4216060686837915`"}], 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "1.5182799921498058`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.076116478784119`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.662313670297611`"}],
  SequenceForm[
  "\[Mu]l = ", -0.4216060686837915, " \[Sigma]l = ", 1.5182799921498058`, 
   " \[Mu]r = ", 5.076116478784119 " \[Sigma]r = ", 0.662313670297611],
  Editable->False]], "Print",
 CellChangeTimes->{3.8914909506894035`*^9, 3.8926187077718725`*^9, 
  3.8926190298167424`*^9, 3.892628549399665*^9, 3.90231112507862*^9, 
  3.9023114117913237`*^9, 3.9023124311816354`*^9},
 CellLabel->
  "During evaluation of \
In[1743]:=",ExpressionUUID->"cfeb53e7-11d2-48a5-bf75-e3a4d525e51c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.44094957178009353`"}], 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "1.5216291564742985`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.005085807280305`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.6475067426904826`"}],
  SequenceForm[
  "\[Mu]l = ", -0.44094957178009353`, " \[Sigma]l = ", 1.5216291564742985`, 
   " \[Mu]r = ", 5.005085807280305 " \[Sigma]r = ", 0.6475067426904826],
  Editable->False]], "Print",
 CellChangeTimes->{3.8914909506894035`*^9, 3.8926187077718725`*^9, 
  3.8926190298167424`*^9, 3.892628549399665*^9, 3.90231112507862*^9, 
  3.9023114117913237`*^9, 3.9023124361274447`*^9},
 CellLabel->
  "During evaluation of \
In[1743]:=",ExpressionUUID->"7d260e02-4a17-4cba-8115-7fcc31fd68a6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.45383986930935033`"}], 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "1.3737117484955699`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.765727837337202`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.7756873955949619`"}],
  SequenceForm[
  "\[Mu]l = ", -0.45383986930935033`, " \[Sigma]l = ", 1.3737117484955699`, 
   " \[Mu]r = ", 4.765727837337202 " \[Sigma]r = ", 0.7756873955949619],
  Editable->False]], "Print",
 CellChangeTimes->{3.8914909506894035`*^9, 3.8926187077718725`*^9, 
  3.8926190298167424`*^9, 3.892628549399665*^9, 3.90231112507862*^9, 
  3.9023114117913237`*^9, 3.902312438722187*^9},
 CellLabel->
  "During evaluation of \
In[1743]:=",ExpressionUUID->"ba9aa422-b0b0-4b3a-afea-e98ff645f331"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.5034718052426363`"}], 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "1.3091835451467038`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.72947648470796`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.8216713243274709`"}],
  SequenceForm[
  "\[Mu]l = ", -0.5034718052426363, " \[Sigma]l = ", 1.3091835451467038`, 
   " \[Mu]r = ", 4.72947648470796 " \[Sigma]r = ", 0.8216713243274709],
  Editable->False]], "Print",
 CellChangeTimes->{3.8914909506894035`*^9, 3.8926187077718725`*^9, 
  3.8926190298167424`*^9, 3.892628549399665*^9, 3.90231112507862*^9, 
  3.9023114117913237`*^9, 3.9023124411993036`*^9},
 CellLabel->
  "During evaluation of \
In[1743]:=",ExpressionUUID->"66e8bad2-b897-4a24-9ffe-61d04cf0444e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.5651076862447638`"}], 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "1.2867601751860336`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.716663359142369`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.8166413496989253`"}],
  SequenceForm[
  "\[Mu]l = ", -0.5651076862447638, " \[Sigma]l = ", 1.2867601751860336`, 
   " \[Mu]r = ", 4.716663359142369 " \[Sigma]r = ", 0.8166413496989253],
  Editable->False]], "Print",
 CellChangeTimes->{3.8914909506894035`*^9, 3.8926187077718725`*^9, 
  3.8926190298167424`*^9, 3.892628549399665*^9, 3.90231112507862*^9, 
  3.9023114117913237`*^9, 3.9023124436104245`*^9},
 CellLabel->
  "During evaluation of \
In[1743]:=",ExpressionUUID->"51244141-6f44-4e10-b52a-e6786bb30e41"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.9132463508474937`"}], 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "1.157638407966085`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.695579262577443`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.8142816425610429`"}],
  SequenceForm[
  "\[Mu]l = ", -0.9132463508474937, " \[Sigma]l = ", 1.157638407966085, 
   " \[Mu]r = ", 4.695579262577443 " \[Sigma]r = ", 0.8142816425610429],
  Editable->False]], "Print",
 CellChangeTimes->{3.8914909506894035`*^9, 3.8926187077718725`*^9, 
  3.8926190298167424`*^9, 3.892628549399665*^9, 3.90231112507862*^9, 
  3.9023114117913237`*^9, 3.902312446139031*^9},
 CellLabel->
  "During evaluation of \
In[1743]:=",ExpressionUUID->"5da79e79-7136-4c16-880f-7609b9f26242"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1.0317108448940135`"}], 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "1.0915963359009584`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.731992578783481`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.8048232417269217`"}],
  SequenceForm[
  "\[Mu]l = ", -1.0317108448940135`, " \[Sigma]l = ", 1.0915963359009584`, 
   " \[Mu]r = ", 4.731992578783481 " \[Sigma]r = ", 0.8048232417269217],
  Editable->False]], "Print",
 CellChangeTimes->{3.8914909506894035`*^9, 3.8926187077718725`*^9, 
  3.8926190298167424`*^9, 3.892628549399665*^9, 3.90231112507862*^9, 
  3.9023114117913237`*^9, 3.9023124486255884`*^9},
 CellLabel->
  "During evaluation of \
In[1743]:=",ExpressionUUID->"7445b9e1-d66b-41a8-8ce5-b7db232b4edb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1.1607361908562677`"}], 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.999096451832282`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.854866715877951`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.7556348577733687`"}],
  SequenceForm[
  "\[Mu]l = ", -1.1607361908562677`, " \[Sigma]l = ", 0.999096451832282, 
   " \[Mu]r = ", 4.854866715877951 " \[Sigma]r = ", 0.7556348577733687],
  Editable->False]], "Print",
 CellChangeTimes->{3.8914909506894035`*^9, 3.8926187077718725`*^9, 
  3.8926190298167424`*^9, 3.892628549399665*^9, 3.90231112507862*^9, 
  3.9023114117913237`*^9, 3.90231245361133*^9},
 CellLabel->
  "During evaluation of \
In[1743]:=",ExpressionUUID->"c69139a8-96a6-4593-91ab-89bc941b0f70"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1.2477211602230334`"}], 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.9457267363917163`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.943892926716509`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.7050784043033871`"}],
  SequenceForm[
  "\[Mu]l = ", -1.2477211602230334`, " \[Sigma]l = ", 0.9457267363917163, 
   " \[Mu]r = ", 4.943892926716509 " \[Sigma]r = ", 0.7050784043033871],
  Editable->False]], "Print",
 CellChangeTimes->{3.8914909506894035`*^9, 3.8926187077718725`*^9, 
  3.8926190298167424`*^9, 3.892628549399665*^9, 3.90231112507862*^9, 
  3.9023114117913237`*^9, 3.9023124560183277`*^9},
 CellLabel->
  "During evaluation of \
In[1743]:=",ExpressionUUID->"b66337fd-19d5-4905-bc8c-cd2691aa8646"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1.177252366321906`"}], 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.9777731096904897`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.928749626697511`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.7072081780215693`"}],
  SequenceForm[
  "\[Mu]l = ", -1.177252366321906, " \[Sigma]l = ", 0.9777731096904897, 
   " \[Mu]r = ", 4.928749626697511 " \[Sigma]r = ", 0.7072081780215693],
  Editable->False]], "Print",
 CellChangeTimes->{3.8914909506894035`*^9, 3.8926187077718725`*^9, 
  3.8926190298167424`*^9, 3.892628549399665*^9, 3.90231112507862*^9, 
  3.9023114117913237`*^9, 3.9023124585490265`*^9},
 CellLabel->
  "During evaluation of \
In[1743]:=",ExpressionUUID->"1a0752af-991e-48e3-babf-4f2e26455355"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1.191361643344622`"}], 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.978853910994952`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.914910526372216`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.709397245782195`"}],
  SequenceForm[
  "\[Mu]l = ", -1.191361643344622, " \[Sigma]l = ", 0.978853910994952, 
   " \[Mu]r = ", 4.914910526372216 " \[Sigma]r = ", 0.709397245782195],
  Editable->False]], "Print",
 CellChangeTimes->{3.8914909506894035`*^9, 3.8926187077718725`*^9, 
  3.8926190298167424`*^9, 3.892628549399665*^9, 3.90231112507862*^9, 
  3.9023114117913237`*^9, 3.9023124613654103`*^9},
 CellLabel->
  "During evaluation of \
In[1743]:=",ExpressionUUID->"85a92d4c-3f29-4ee8-97c4-9acfc860fa69"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1.1941498538260527`"}], 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.9748235775798889`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.930642595762874`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.7016182942708001`"}],
  SequenceForm[
  "\[Mu]l = ", -1.1941498538260527`, " \[Sigma]l = ", 0.9748235775798889, 
   " \[Mu]r = ", 4.930642595762874 " \[Sigma]r = ", 0.7016182942708001],
  Editable->False]], "Print",
 CellChangeTimes->{3.8914909506894035`*^9, 3.8926187077718725`*^9, 
  3.8926190298167424`*^9, 3.892628549399665*^9, 3.90231112507862*^9, 
  3.9023114117913237`*^9, 3.902312463887742*^9},
 CellLabel->
  "During evaluation of \
In[1743]:=",ExpressionUUID->"cb026bd3-47d3-4e4e-908b-3099a6b4372b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1.193337220900255`"}], 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.9752737704630539`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.930848566276952`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.7013697593007712`"}],
  SequenceForm[
  "\[Mu]l = ", -1.193337220900255, " \[Sigma]l = ", 0.9752737704630539, 
   " \[Mu]r = ", 4.930848566276952 " \[Sigma]r = ", 0.7013697593007712],
  Editable->False]], "Print",
 CellChangeTimes->{3.8914909506894035`*^9, 3.8926187077718725`*^9, 
  3.8926190298167424`*^9, 3.892628549399665*^9, 3.90231112507862*^9, 
  3.9023114117913237`*^9, 3.9023124665215654`*^9},
 CellLabel->
  "During evaluation of \
In[1743]:=",ExpressionUUID->"6c94d13d-b6c2-4122-a441-4f0f764e2cfd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1.1932246047074784`"}], 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.9753549219969198`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.930869868202504`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.7013451310304348`"}],
  SequenceForm[
  "\[Mu]l = ", -1.1932246047074784`, " \[Sigma]l = ", 0.9753549219969198, 
   " \[Mu]r = ", 4.930869868202504 " \[Sigma]r = ", 0.7013451310304348],
  Editable->False]], "Print",
 CellChangeTimes->{3.8914909506894035`*^9, 3.8926187077718725`*^9, 
  3.8926190298167424`*^9, 3.892628549399665*^9, 3.90231112507862*^9, 
  3.9023114117913237`*^9, 3.9023124693789682`*^9},
 CellLabel->
  "During evaluation of \
In[1743]:=",ExpressionUUID->"d680f872-0c97-448f-9620-42e8a247faaa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1.1932210130893037`"}], 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.9753577224625313`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.930869899882536`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.7013459041886663`"}],
  SequenceForm[
  "\[Mu]l = ", -1.1932210130893037`, " \[Sigma]l = ", 0.9753577224625313, 
   " \[Mu]r = ", 4.930869899882536 " \[Sigma]r = ", 0.7013459041886663],
  Editable->False]], "Print",
 CellChangeTimes->{3.8914909506894035`*^9, 3.8926187077718725`*^9, 
  3.8926190298167424`*^9, 3.892628549399665*^9, 3.90231112507862*^9, 
  3.9023114117913237`*^9, 3.9023124720242825`*^9},
 CellLabel->
  "During evaluation of \
In[1743]:=",ExpressionUUID->"6655686d-6342-4b81-a3a0-ea85c82c3354"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1.193220211003068`"}], 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.9753583204633655`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.930870493412719`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.7013455190431324`"}],
  SequenceForm[
  "\[Mu]l = ", -1.193220211003068, " \[Sigma]l = ", 0.9753583204633655, 
   " \[Mu]r = ", 4.930870493412719 " \[Sigma]r = ", 0.7013455190431324],
  Editable->False]], "Print",
 CellChangeTimes->{3.8914909506894035`*^9, 3.8926187077718725`*^9, 
  3.8926190298167424`*^9, 3.892628549399665*^9, 3.90231112507862*^9, 
  3.9023114117913237`*^9, 3.902312474646371*^9},
 CellLabel->
  "During evaluation of \
In[1743]:=",ExpressionUUID->"5f15a0c4-26bc-4a44-83d5-1a8a6b5817d5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1.193219784063446`"}], 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.9753585102338281`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.9308700790294715`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.7013458091694645`"}],
  SequenceForm[
  "\[Mu]l = ", -1.193219784063446, " \[Sigma]l = ", 0.9753585102338281, 
   " \[Mu]r = ", 4.9308700790294715` " \[Sigma]r = ", 0.7013458091694645],
  Editable->False]], "Print",
 CellChangeTimes->{3.8914909506894035`*^9, 3.8926187077718725`*^9, 
  3.8926190298167424`*^9, 3.892628549399665*^9, 3.90231112507862*^9, 
  3.9023114117913237`*^9, 3.902312477594833*^9},
 CellLabel->
  "During evaluation of \
In[1743]:=",ExpressionUUID->"55eb5846-2912-4d7d-ae4c-e21bf0791763"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1.193219784642609`"}], 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.9753585098925333`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.930870078832332`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.7013458092616099`"}],
  SequenceForm[
  "\[Mu]l = ", -1.193219784642609, " \[Sigma]l = ", 0.9753585098925333, 
   " \[Mu]r = ", 4.930870078832332 " \[Sigma]r = ", 0.7013458092616099],
  Editable->False]], "Print",
 CellChangeTimes->{3.8914909506894035`*^9, 3.8926187077718725`*^9, 
  3.8926190298167424`*^9, 3.892628549399665*^9, 3.90231112507862*^9, 
  3.9023114117913237`*^9, 3.902312501127833*^9},
 CellLabel->
  "During evaluation of \
In[1743]:=",ExpressionUUID->"6ed44255-e01e-46b4-b033-cfd13d041034"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1.193219784728701`"}], 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.9753585097778791`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.930870078627273`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.7013458093308707`"}],
  SequenceForm[
  "\[Mu]l = ", -1.193219784728701, " \[Sigma]l = ", 0.9753585097778791, 
   " \[Mu]r = ", 4.930870078627273 " \[Sigma]r = ", 0.7013458093308707],
  Editable->False]], "Print",
 CellChangeTimes->{3.8914909506894035`*^9, 3.8926187077718725`*^9, 
  3.8926190298167424`*^9, 3.892628549399665*^9, 3.90231112507862*^9, 
  3.9023114117913237`*^9, 3.902312524717225*^9},
 CellLabel->
  "During evaluation of \
In[1743]:=",ExpressionUUID->"07989621-734d-46b6-8660-6c6b24ea037c"]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
  "FindMinimum", "lstol", 
   "\"The line search decreased the step size to within the tolerance \
specified by AccuracyGoal and PrecisionGoal but was unable to find a \
sufficient decrease in the function. You may need more than \\!\\(\\*RowBox[{\
\\\"MachinePrecision\\\"}]\\) digits of working precision to meet these \
tolerances.\"", 2, 1743, 115, 17025713724928210084, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.891491200831779*^9, 3.892618856196306*^9, 
  3.8926192341151314`*^9, 3.8926287878118887`*^9, 3.902311235152139*^9, 
  3.9023116280901785`*^9, 3.9023125828914375`*^9},
 CellLabel->
  "During evaluation of \
In[1743]:=",ExpressionUUID->"f49466cf-8296-4d36-bbca-a5532ec564aa"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Mu]l", "\[Rule]", "1.193219784827523`"}], ",", 
   RowBox[{"\[Sigma]l", "\[Rule]", "0.9753585096493816`"}], ",", 
   RowBox[{"\[Mu]r", "\[Rule]", "4.930870078417297`"}], ",", 
   RowBox[{"\[Sigma]r", "\[Rule]", "0.7013458093994477`"}], ",", 
   RowBox[{"\[Mu]lx", "\[Rule]", "0.48794251672925504`"}], ",", 
   RowBox[{"\[Sigma]lx", "\[Rule]", "0.6151049082618393`"}], ",", 
   RowBox[{"\[Mu]rx", "\[Rule]", "177.1174462381427`"}], ",", 
   RowBox[{"\[Sigma]rx", "\[Rule]", "141.18355742998077`"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.8890831915134697`*^9, 3.889083231716405*^9, 
  3.889084522029305*^9, 3.889504478964719*^9, 3.889668839037505*^9, 
  3.8896689977438555`*^9, 3.8902046298151426`*^9, 3.8902062509864902`*^9, 
  3.8902104624878206`*^9, 3.890216989995762*^9, 3.8902173041350584`*^9, 
  3.8902179907784314`*^9, 3.8909820012674875`*^9, 3.8909824058680325`*^9, 
  3.890982955030755*^9, 3.8909840701831517`*^9, 3.8909841450834846`*^9, 
  3.8909843770126934`*^9, 3.8909844264654613`*^9, 3.890984470131813*^9, 
  3.8914172771083*^9, 3.8914183694354115`*^9, 3.89142833097868*^9, 
  3.8914909230011034`*^9, 3.891491200867608*^9, 3.8926188562515326`*^9, 
  3.892619234142315*^9, 3.892628787877736*^9, 3.9023112351844745`*^9, 
  3.9023116281409287`*^9, 3.9023125829339814`*^9},
 CellLabel->
  "Out[1743]=",ExpressionUUID->"47166bd1-481f-43ab-a8ea-c73247443daa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"ColorData", "[", 
    RowBox[{"\"\<SunsetColors\>\"", ",", "\"\<Image\>\""}], "]"}], "*)"}], 
  " ", 
  RowBox[{"(*", " ", 
   RowBox[{"Visualize", " ", "a", " ", "color", " ", "scheme"}], "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"plotIntensityFitPlatelets", " ", "=", " ", 
    RowBox[{"ListLogLogPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"datamerged", "[", 
         RowBox[{"[", 
          RowBox[{"1", ";;", 
           RowBox[{"-", "1"}]}], "]"}], "]"}], ",", 
        RowBox[{
         RowBox[{"calculateIntensitiesLR", "[", 
          RowBox[{
          "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r"}], 
          "]"}], "/.", "fitSlopeLRResult"}]}], "}"}], ",", " ", 
      RowBox[{"(*", 
       RowBox[{"Optional", ":", " ", 
        RowBox[{
        "Plot", " ", "every", " ", "2", "nd", " ", "point", " ", "only", " ", 
         "for", " ", "readibility"}], ":", " ", 
        RowBox[{"datamerged", "[", 
         RowBox[{"[", 
          RowBox[{"1", ";;", 
           RowBox[{"-", "1"}], ";;", "2"}], "]"}], "]"}]}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"5", " ", 
            RowBox[{"10", "^", 
             RowBox[{"-", "3"}]}]}], ",", " ", 
           RowBox[{"10", "^", "0"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"10", "^", 
            RowBox[{"-", "6"}]}], ",", " ", 
           RowBox[{"10", "^", "4"}]}], "}"}]}], "}"}]}], ",", " ", 
      "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"False", ",", "True"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"Black", ",", " ", 
           RowBox[{"PointSize", "[", "0.04", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.004", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           
           TemplateBox[<|
            "color" -> RGBColor[
              0.6745098039215687, 0.07450980392156863, 0.043137254901960784`]|>,
            "RGBColorSwatchTemplate"], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}]}], "}"}]}], ",", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{
        "third", " ", "color", " ", "not", " ", "currently", " ", "used"}], 
        ",", " ", 
        RowBox[{
        "but", " ", "left", " ", "here", " ", "for", " ", "reference", " ", 
         "as", " ", "it", " ", "has", " ", "a", " ", "pretty", " ", "decent", 
         " ", "contrast", " ", "with", " ", "the", " ", "first", " ", 
         "color"}]}], " ", "*)"}], 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"ColorData", "[", "9", "]"}], "[", "i", "]"}], ",", 
            RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
            RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{"i", ",", 
            RowBox[{"Length", "[", "datamerged", "]"}]}], "}"}]}], "]"}], 
        ","}], "*)"}], 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "Automatic"}], "}"}], ","}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}]}], "]"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"FitToPlot", " ", "=", " ", 
     RowBox[{
      RowBox[{"calculateIntensitiesLR", "[", 
       RowBox[{"\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r"}], 
       "]"}], "/.", "fitSlopeLRResult"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotIntensityFitPlateletsA", " ", "=", " ", 
     RowBox[{"ListLogLogPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"datamerged", "[", 
         RowBox[{"[", 
          RowBox[{"1", ";;", 
           RowBox[{"-", "1"}]}], "]"}], "]"}], "}"}], ",", " ", 
       RowBox[{"(*", 
        RowBox[{"Optional", ":", " ", 
         RowBox[{
         "Plot", " ", "every", " ", "2", "nd", " ", "point", " ", "only", " ",
           "for", " ", "readibility"}], ":", " ", 
         RowBox[{"datamerged", "[", 
          RowBox[{"[", 
           RowBox[{"1", ";;", 
            RowBox[{"-", "1"}], ";;", "2"}], "]"}], "]"}]}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"5", " ", 
             RowBox[{"10", "^", 
              RowBox[{"-", "3"}]}]}], ",", " ", 
            RowBox[{"10", "^", "0"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"10", "^", 
             RowBox[{"-", "3"}]}], ",", " ", 
            RowBox[{"10", "^", "4"}]}], "}"}]}], "}"}]}], ",", " ", 
       "\[IndentingNewLine]", 
       RowBox[{"Joined", "\[Rule]", 
        RowBox[{"{", "False", "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
       RowBox[{"FrameTicks", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
            RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
            RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"FrameLabel", " ", "->", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
           "\"\<\!\(\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
         "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotStyle", "->", " ", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], "}"}]}], ",", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{
         "third", " ", "color", " ", "not", " ", "currently", " ", "used"}], 
         ",", " ", 
         RowBox[{
         "but", " ", "left", " ", "here", " ", "for", " ", "reference", " ", 
          "as", " ", "it", " ", "has", " ", "a", " ", "pretty", " ", "decent",
           " ", "contrast", " ", "with", " ", "the", " ", "first", " ", 
          "color"}]}], " ", "*)"}], 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"ColorData", "[", "9", "]"}], "[", "i", "]"}], ",", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
             RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"i", ",", 
             RowBox[{"Length", "[", "datamerged", "]"}]}], "}"}]}], "]"}], 
         ","}], "*)"}], 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", "Automatic"}], "}"}], ","}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"LabelStyle", "\[Rule]", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
         "}"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotIntensityFitPlateletsB", " ", "=", " ", 
     RowBox[{"ListLogLogPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"FitToPlot", ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1000"}], "}"}]}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"(*", 
        RowBox[{"Optional", ":", " ", 
         RowBox[{
         "Plot", " ", "every", " ", "2", "nd", " ", "point", " ", "only", " ",
           "for", " ", "readibility"}], ":", " ", 
         RowBox[{"datamerged", "[", 
          RowBox[{"[", 
           RowBox[{"1", ";;", 
            RowBox[{"-", "1"}], ";;", "2"}], "]"}], "]"}]}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"Joined", "\[Rule]", 
        RowBox[{"{", "True", "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotStyle", "->", " ", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"Black", ",", " ", 
           RowBox[{"PointSize", "[", "0.04", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.004", "]"}]}], "}"}], "}"}]}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"plotIntensityFitPlatelets", " ", "=", " ", 
    RowBox[{"Show", "[", 
     RowBox[{
     "plotIntensityFitPlateletsA", ",", " ", "plotIntensityFitPlateletsB"}], 
     "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<PlateletsIntensityFit.pdf\>\""}], "}"}], "]"}], ",", 
     "plotIntensityFitPlatelets"}], "]"}], "\n", "\n", "\[IndentingNewLine]", 
   RowBox[{"plotPlateletsFit", " ", "=", " ", 
    RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"slope", "[", 
         RowBox[{"datamerged", ",", "0.15"}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"slope", "[", 
         RowBox[{
          RowBox[{"calculateIntensitiesLR", "[", 
           RowBox[{
           "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r"}], 
           "]"}], "/.", "fitSlopeLRResult"}], "]"}]}], "\[IndentingNewLine]", 
       "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", " ", "Automatic"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Slope\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<Binned data\>\"", ",", " ", 
         "\"\<Platelets form factor fit\>\""}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           
           TemplateBox[<|
            "color" -> RGBColor[
              0.6745098039215687, 0.07450980392156863, 0.043137254901960784`]|>,
            "RGBColorSwatchTemplate"], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"Black", ",", " ", 
           RowBox[{"PointSize", "[", "0.04", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.004", "]"}], ",", " ", "Dashed"}], 
          "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameStyle", "\[Rule]", "Black"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Joined", "->", 
       RowBox[{"{", 
        RowBox[{"False", ",", "True"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotMarkers", "->", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "\"\<\>\"", ",", "\"\<\>\""}], "}"}]}]}], 
     "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<PlateletsSlopeFit.pdf\>\""}], "}"}], "]"}], ",", 
     "plotPlateletsFit"}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"plot3Dprobability", " ", "=", " ", 
    RowBox[{"ListPlot3D", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Flatten", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"l", ",", "r", ",", 
            RowBox[{
             RowBox[{"probfunc", "[", 
              RowBox[{
              "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r", 
               ",", "l", ",", "r"}], "]"}], "/.", "fitSlopeLRResult"}]}], 
           "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"r", ",", "radii"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"l", ",", "lengths"}], "}"}]}], "]"}], ",", "1"}], "]"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ScalingFunctions", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<Log\>\"", ",", "\"\<Log\>\"", ",", "None"}], "}"}]}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"Ticks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
         RowBox[{"PowerTicks", "[", "True", "]"}], ",", "Automatic"}], 
        "}"}]}], ",", " ", "\[IndentingNewLine]", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
        "\"\<Length (nm)\>\"", ",", "\"\<Radius (nm)\>\"", ",", 
         "\"\<Probability\>\""}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "12"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"LabelStyle", "\[Rule]", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
          "}"}]}], ","}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"ColorFunction", "->", 
         RowBox[{"(", 
          RowBox[{"ColorData", "[", "9", "]"}], ")"}]}], ","}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"BoxStyle", "\[Rule]", "Black"}]}], "\[IndentingNewLine]", 
     "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<PlateletsFit3Dprobability.pdf\>\""}], "}"}], "]"}], ",", " ", 
     "plot3Dprobability"}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"plot2Ddensity", " ", "=", " ", 
    RowBox[{"ListDensityPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Flatten", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"l", ",", "r", ",", 
            RowBox[{
             RowBox[{"probfunc", "[", 
              RowBox[{
              "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r", 
               ",", "l", ",", "r"}], "]"}], "/.", "fitSlopeLRResult"}]}], 
           "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"r", ",", "radii"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"l", ",", "lengths"}], "}"}]}], "]"}], ",", "1"}], "]"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ScalingFunctions", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<Log\>\"", ",", "\"\<Log\>\"", ",", "None"}], "}"}]}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<Length (nm)\>\"", ",", "\"\<Radius (nm)\>\""}], "}"}]}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameStyle", "\[Rule]", "Black"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ColorFunction", "->", "\"\<SunsetColors\>\""}], ",", " ", 
      RowBox[{"(*", 
       RowBox[{"\"\<CherryTones\>\"", ",", " ", 
        RowBox[{"\"\<SunsetColors\>\"", " ", 
         RowBox[{"(", 
          RowBox[{"one", " ", "directionally", " ", 
           RowBox[{"continuous", "/", "best"}]}], ")"}]}], ",", " ", 
        "\"\<LightTemperatureMap\>\"", ",", " ", 
        "\"\<ThermometerColors\>\""}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "->", " ", "Automatic"}], ",", " ", 
      RowBox[{"(*", " ", 
       RowBox[{"PlotLegends", "->", " ", 
        RowBox[{"BarLegend", "[", "\"\<SunsetColors\>\"", "]"}]}], " ", 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{"AspectRatio", "->", "Automatic"}]}], "\[IndentingNewLine]", 
     "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<PlateletsFit2Ddensity.pdf\>\""}], "}"}], "]"}], ",", 
     "plot2Ddensity"}], "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"plotPlateletDistributions", " ", "=", " ", 
    RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"lengths", ",", 
           RowBox[{
            RowBox[{
             RowBox[{"#", "/", 
              RowBox[{"Max", "[", "#", "]"}]}], "&"}], "@", 
            RowBox[{"PDF", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"LogNormalDistribution", "[", 
                RowBox[{"\[Mu]l", ",", "\[Sigma]l"}], "]"}], "/.", 
               "fitSlopeLRResult"}], ",", "lengths"}], "]"}]}]}], "}"}], 
         "\[Transpose]"}], ",", " ", 
        RowBox[{"(*", " ", 
         RowBox[{
         "Probability", " ", "normalized", " ", "by", " ", "the", " ", 
          "maximum", " ", "probability"}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"radii", ",", 
           RowBox[{
            RowBox[{
             RowBox[{"#", "/", 
              RowBox[{"Max", "[", "#", "]"}]}], "&"}], "@", 
            RowBox[{"PDF", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"LogNormalDistribution", "[", 
                RowBox[{"\[Mu]r", ",", "\[Sigma]r"}], "]"}], "/.", 
               "fitSlopeLRResult"}], ",", "radii"}], "]"}]}]}], "}"}], 
         "\[Transpose]"}]}], "\[IndentingNewLine]", "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Frame", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "->", "All"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<Size (nm)\>\"", ",", "\"\<Normalized probability\>\""}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", " ", "Automatic"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<Platelets thickness fit distribution\>\"", ",", " ", 
         "\"\<Platelets radii fit distribution\>\""}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Joined", "->", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           
           TemplateBox[<|
            "color" -> RGBColor[
              0.6745098039215687, 0.07450980392156863, 0.043137254901960784`]|>,
            "RGBColorSwatchTemplate"], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"Black", ",", " ", 
           RowBox[{"PointSize", "[", "0.04", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.004", "]"}], ",", " ", "Dashed"}], 
          "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameStyle", "\[Rule]", "Black"}]}], "\[IndentingNewLine]", 
     "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<PlateletFitDistributions.pdf\>\""}], "}"}], "]"}], ",", 
     "plotPlateletDistributions"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.889083294305049*^9, 3.889083315851309*^9}, {
   3.8890833883662243`*^9, 3.8890834456873417`*^9}, {3.889083486103497*^9, 
   3.8890835217014627`*^9}, {3.889083563050894*^9, 3.8890835639046907`*^9}, {
   3.88908424900935*^9, 3.889084266338831*^9}, {3.8895047640723577`*^9, 
   3.8895048132399473`*^9}, {3.889504846884196*^9, 3.8895048547452297`*^9}, {
   3.8895049269182625`*^9, 3.8895050026520877`*^9}, {3.8895050961729617`*^9, 
   3.889505131901743*^9}, {3.8895051665115204`*^9, 3.88950517791572*^9}, {
   3.889514960971097*^9, 3.889515036411804*^9}, {3.8895151686784644`*^9, 
   3.8895152527812395`*^9}, {3.889515322726761*^9, 3.889515322942603*^9}, {
   3.889515414799749*^9, 3.889515415134011*^9}, {3.889515802135846*^9, 
   3.8895158072956295`*^9}, {3.88951762311401*^9, 3.8895176529460897`*^9}, {
   3.8895177805499964`*^9, 3.8895178521346097`*^9}, {3.8895178958654327`*^9, 
   3.889517895992517*^9}, {3.8895179853740325`*^9, 3.8895179941825094`*^9}, {
   3.889518050385213*^9, 3.8895180651462665`*^9}, {3.889518110111107*^9, 
   3.8895181537599416`*^9}, {3.8895181952428894`*^9, 3.889518231543586*^9}, {
   3.8895182640986247`*^9, 3.889518360154647*^9}, {3.889518402957049*^9, 
   3.8895184404208817`*^9}, {3.889518524888457*^9, 3.8895185272255807`*^9}, {
   3.8895889126133003`*^9, 3.889588935610735*^9}, {3.889589038336623*^9, 
   3.889589077704085*^9}, {3.889592078032647*^9, 3.8895920808209195`*^9}, {
   3.889592118364094*^9, 3.8895924083479843`*^9}, {3.8895925522801237`*^9, 
   3.8895925725829153`*^9}, {3.8895927385856147`*^9, 3.889592740371332*^9}, {
   3.8895928489211516`*^9, 3.8895928588784356`*^9}, {3.8895928981345015`*^9, 
   3.889592939760598*^9}, {3.889592994486616*^9, 3.889593006731392*^9}, {
   3.8896690677438173`*^9, 3.8896690861177497`*^9}, {3.8896691662237344`*^9, 
   3.8896691680709915`*^9}, {3.8896692820528316`*^9, 
   3.8896693106620665`*^9}, {3.889669383022016*^9, 3.8896694349828773`*^9}, {
   3.8896699958407335`*^9, 3.8896699966198225`*^9}, {3.8896701115288887`*^9, 
   3.8896701256913085`*^9}, {3.8896701570270524`*^9, 3.889670157394929*^9}, {
   3.8896712449546976`*^9, 3.889671273339734*^9}, {3.8896722465178547`*^9, 
   3.8896723216246796`*^9}, {3.889677150823584*^9, 3.889677160683831*^9}, {
   3.8896771908757315`*^9, 3.889677195202493*^9}, 3.8896773421424313`*^9, {
   3.889677378283571*^9, 3.8896773887669315`*^9}, {3.88967742719445*^9, 
   3.889677430963851*^9}, {3.889677480339917*^9, 3.889677480743126*^9}, {
   3.889677596624218*^9, 3.8896775968970366`*^9}, {3.889680706734044*^9, 
   3.8896807216712313`*^9}, {3.889680801340059*^9, 3.8896808079046683`*^9}, 
   3.8896849744898243`*^9, {3.889685151140499*^9, 3.8896851850751715`*^9}, 
   3.903585376894636*^9, {3.9052296305196075`*^9, 
   3.9052296380591927`*^9}},ExpressionUUID->"53db37f2-ab19-4a4d-8175-\
4749ca30cef4"],

Cell[BoxData[
 GraphicsBox[{{}, {{{}, {}, {}, 
     {GrayLevel[0], PointSize[0.04], Thickness[0.004], LineBox[CompressedData["
1:eJw1lAdUU2kahkMLUgJpJCGBkADBUJRhXLsIos4gimBBGKqyrA27oqOjYwPH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       "]]}}, {
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.01], Thickness[0.005], PointBox[CompressedData["
1:eJwVV3c41u0Xt589kV5F2oNslaj7S8jKVklE8iIzSZlR2nYkJKNBvZStSN+T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       "]]}, {}}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-5.298317366548025, -13.815510557964243`},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) \
[\\!\\(\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], 
      TraditionalForm], None}},
  FrameTicks->{{{{
       NCache[-Log[1000000], -13.815510557964274`], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "6"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[100000], -11.512925464970229`], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10000], -9.210340371976184], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "4"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[1000000], -13.815510557964274`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500000], -13.122363377404328`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000000, 3]], -12.716898269296165`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250000], -12.429216196844383`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200000], -12.206072645530174`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500000, 3]], -12.02375108873622], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000000, 7]], -11.86960040890896], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125000], -11.736069016284437`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000000, 9]], -11.618285980628055`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100000], -11.512925464970229`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50000], -10.819778284410283`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100000, 3]], -10.41431317630212], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25000], -10.126631103850338`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20000], -9.903487552536127], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50000, 3]], -9.721165995742174], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100000, 7]], -9.567015315914915], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[12500], -9.433483923290392], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100000, 9]], -9.315700887634009], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10000], -9.210340371976184], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5000], -8.517193191416238], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10000, 3]], -8.111728083308073], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2500], -7.824046010856292], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2000], -7.600902459542082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5000, 3]], -7.418580902748128], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10000, 7]], -7.264430222920869], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[1250], -7.1308988302963465`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10000, 9]], -7.013115794639964], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30], 3.4011973816621555`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70], 4.248495242049359], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90], 4.499809670330265], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[300], 5.703782474656201], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[400], 5.991464547107982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[600], 6.396929655216146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[700], 6.551080335043404], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[800], 6.684611727667927], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[900], 6.802394763324311], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[1000000], -13.815510557964274`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100000], -11.512925464970229`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10000], -9.210340371976184], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000000], -13.815510557964274`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500000], -13.122363377404328`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000000, 3]], -12.716898269296165`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250000], -12.429216196844383`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200000], -12.206072645530174`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500000, 3]], -12.02375108873622], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000000, 7]], -11.86960040890896], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125000], -11.736069016284437`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000000, 9]], -11.618285980628055`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100000], -11.512925464970229`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50000], -10.819778284410283`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100000, 3]], -10.41431317630212], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25000], -10.126631103850338`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20000], -9.903487552536127], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50000, 3]], -9.721165995742174], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100000, 7]], -9.567015315914915], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[12500], -9.433483923290392], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100000, 9]], -9.315700887634009], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10000], -9.210340371976184], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5000], -8.517193191416238], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10000, 3]], -8.111728083308073], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2500], -7.824046010856292], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2000], -7.600902459542082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5000, 3]], -7.418580902748128], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10000, 7]], -7.264430222920869], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[1250], -7.1308988302963465`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10000, 9]], -7.013115794639964], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30], 3.4011973816621555`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70], 4.248495242049359], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90], 4.499809670330265], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[300], 5.703782474656201], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[400], 5.991464547107982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[600], 6.396929655216146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[700], 6.551080335043404], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[800], 6.684611727667927], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[900], 6.802394763324311], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}, {{{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  LabelStyle->{FontSize -> 14, 
    GrayLevel[0]},
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{-5.298317366548036, 0.}, {-13.815510557964274`, 
   4.605170185988092}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], 
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0]}]], "Output",
 CellChangeTimes->{
  3.8895182869567413`*^9, {3.8895183343905697`*^9, 3.8895183620551634`*^9}, {
   3.8895184150560637`*^9, 3.8895184418507495`*^9}, 3.8895185281220536`*^9, 
   3.8895889404320927`*^9, {3.8895890406246934`*^9, 3.8895890784682913`*^9}, 
   3.889592148098647*^9, 3.889592411520773*^9, 3.8895925734732924`*^9, 
   3.889592742450922*^9, 3.889592859727005*^9, 3.889592922507035*^9, 
   3.8895930087831736`*^9, 3.889668998234763*^9, 3.8896690890570593`*^9, 
   3.889669169286552*^9, 3.8896693168938737`*^9, 3.8896711091569824`*^9, 
   3.889671276253702*^9, 3.8896723301246977`*^9, 3.889677442821598*^9, 
   3.889677598100257*^9, 3.889684978194605*^9, 3.889685185804984*^9, 
   3.890204642630407*^9, 3.8902063323023443`*^9, 3.8902104829738626`*^9, 
   3.8902169904530506`*^9, 3.890217304571312*^9, 3.8902182374475017`*^9, 
   3.8909820692101192`*^9, 3.8909824066539817`*^9, 3.8909829558379273`*^9, 
   3.8914172809480352`*^9, 3.89141922718013*^9, 3.8914283344573555`*^9, 
   3.8926188577476263`*^9, 3.892619234655546*^9, 3.892628789917142*^9, 
   3.90231123633893*^9, 3.902311628948968*^9, 3.9023125840025635`*^9},
 CellLabel->
  "Out[1744]=",ExpressionUUID->"63558e27-6ffa-4262-bf00-07474f69cbe8"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2022-08_\
new_data\\\\Analysis\\\\Full form factor fit\\\\LH-ESRF-C16 - volume (not \
corrupted)\\\\PlateletsIntensityFit.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.8895182869567413`*^9, {3.8895183343905697`*^9, 3.8895183620551634`*^9}, {
   3.8895184150560637`*^9, 3.8895184418507495`*^9}, 3.8895185281220536`*^9, 
   3.8895889404320927`*^9, {3.8895890406246934`*^9, 3.8895890784682913`*^9}, 
   3.889592148098647*^9, 3.889592411520773*^9, 3.8895925734732924`*^9, 
   3.889592742450922*^9, 3.889592859727005*^9, 3.889592922507035*^9, 
   3.8895930087831736`*^9, 3.889668998234763*^9, 3.8896690890570593`*^9, 
   3.889669169286552*^9, 3.8896693168938737`*^9, 3.8896711091569824`*^9, 
   3.889671276253702*^9, 3.8896723301246977`*^9, 3.889677442821598*^9, 
   3.889677598100257*^9, 3.889684978194605*^9, 3.889685185804984*^9, 
   3.890204642630407*^9, 3.8902063323023443`*^9, 3.8902104829738626`*^9, 
   3.8902169904530506`*^9, 3.890217304571312*^9, 3.8902182374475017`*^9, 
   3.8909820692101192`*^9, 3.8909824066539817`*^9, 3.8909829558379273`*^9, 
   3.8914172809480352`*^9, 3.89141922718013*^9, 3.8914283344573555`*^9, 
   3.8926188577476263`*^9, 3.892619234655546*^9, 3.892628789917142*^9, 
   3.90231123633893*^9, 3.902311628948968*^9, 3.9023125852239757`*^9},
 CellLabel->
  "Out[1745]=",ExpressionUUID->"af5f750c-ce72-48bc-af1a-8dd2aef42da8"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{{Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.962020517152551, -1.7975229365155172`}, \
{-4.962020517152551, -1.4904522790582342`}}], 
          
          LineBox[{{-4.962020517152551, -1.4904522790582342`}, \
{-4.962020517152551, -1.1833816216009512`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.812318020609066, -1.7499804854261338`}, \
{-4.812318020609066, -1.484844590276649}}], 
          
          LineBox[{{-4.812318020609066, -1.484844590276649}, \
{-4.812318020609066, -1.219708695127164}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.662288009830052, -1.731832308155819}, \
{-4.662288009830052, -1.484844094732198}}], 
          
          LineBox[{{-4.662288009830052, -1.484844094732198}, \
{-4.662288009830052, -1.237855881308577}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.510921616983912, -2.1820005297355953`}, \
{-4.510921616983912, -1.9277101971080235`}}], 
          
          LineBox[{{-4.510921616983912, -1.9277101971080235`}, \
{-4.510921616983912, -1.6734198644804519`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.358825697731176, -1.7496301838784403`}, \
{-4.358825697731176, -1.5407870885745718`}}], 
          
          LineBox[{{-4.358825697731176, -1.5407870885745718`}, \
{-4.358825697731176, -1.3319439932707033`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.206267641506683, -2.0186112646490657`}, \
{-4.206267641506683, -1.8301249552977674`}}], 
          
          LineBox[{{-4.206267641506683, -1.8301249552977674`}, \
{-4.206267641506683, -1.6416386459464691`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.056255653469975, -2.045423498599775}, \
{-4.056255653469975, -1.8298421264932705`}}], 
          
          LineBox[{{-4.056255653469975, -1.8298421264932705`}, \
{-4.056255653469975, -1.6142607543867664`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.9071666992729934`, -2.2539753896725387`}, \
{-3.9071666992729934`, -2.048083845765819}}], 
          
          LineBox[{{-3.9071666992729934`, -2.048083845765819}, \
{-3.9071666992729934`, -1.8421923018590989`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.7563029605395606`, -2.356016322351946}, \
{-3.7563029605395606`, -2.1793864693343323`}}], 
          
          LineBox[{{-3.7563029605395606`, -2.1793864693343323`}, \
{-3.7563029605395606`, -2.0027566163167188`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.6055069407082008`, -2.0712591417540867`}, \
{-3.6055069407082008`, -1.9041921854873916`}}], 
          
          LineBox[{{-3.6055069407082008`, -1.9041921854873916`}, \
{-3.6055069407082008`, -1.7371252292206965`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.4564260807134493`, -2.3154337014558}, \
{-3.4564260807134493`, -2.1486849495091764`}}], 
          
          LineBox[{{-3.4564260807134493`, -2.1486849495091764`}, \
{-3.4564260807134493`, -1.9819361975625527`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.3071524238710044`, -2.236134018237064}, \
{-3.3071524238710044`, -2.0916457307990073`}}], 
          
          LineBox[{{-3.3071524238710044`, -2.0916457307990073`}, \
{-3.3071524238710044`, -1.9471574433609504`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.156690529396256, -2.207572101104361}, \
{-3.156690529396256, -2.0758943792454656`}}], 
          
          LineBox[{{-3.156690529396256, -2.0758943792454656`}, \
{-3.156690529396256, -1.9442166573865698`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.0195378319942416`, -2.242122341649085}, \
{-3.0195378319942416`, -2.0720360768688115`}}], 
          
          LineBox[{{-3.0195378319942416`, -2.0720360768688115`}, \
{-3.0195378319942416`, -1.9019498120885379`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.8585261080745212`, -2.317698131453854}, \
{-2.8585261080745212`, -2.0032105152590582`}}], 
          
          LineBox[{{-2.8585261080745212`, -2.0032105152590582`}, \
{-2.8585261080745212`, -1.6887228990642622`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.691382454472379, -2.78784802624227}, \
{-2.691382454472379, -2.1892779813885275`}}], 
          
          LineBox[{{-2.691382454472379, -2.1892779813885275`}, \
{-2.691382454472379, -1.5907079365347847`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.5545155316419494`, -2.7417402803813147`}, \
{-2.5545155316419494`, -2.1924652191783975`}}], 
          
          LineBox[{{-2.5545155316419494`, -2.1924652191783975`}, \
{-2.5545155316419494`, -1.6431901579754804`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.408966023604327, -2.7235790038725742`}, \
{-2.408966023604327, -2.242770317295063}}], 
          
          LineBox[{{-2.408966023604327, -2.242770317295063}, \
{-2.408966023604327, -1.7619616307175516`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.2588388882868426`, -2.729795390355834}, \
{-2.2588388882868426`, -2.268822869979683}}], 
          
          LineBox[{{-2.2588388882868426`, -2.268822869979683}, \
{-2.2588388882868426`, -1.807850349603532}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.1096964413451786`, -2.7535327288177047`}, \
{-2.1096964413451786`, -2.3379921382936306`}}], 
          
          LineBox[{{-2.1096964413451786`, -2.3379921382936306`}, \
{-2.1096964413451786`, -1.9224515477695563`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.9578947894818906`, -2.7345648695754594`}, \
{-1.9578947894818906`, -2.3436357189221946`}}], 
          
          LineBox[{{-1.9578947894818906`, -2.3436357189221946`}, \
{-1.9578947894818906`, -1.9527065682689297`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.8071283500440232`, -2.7889862251377617`}, \
{-1.8071283500440232`, -2.4214478851744476`}}], 
          
          LineBox[{{-1.8071283500440232`, -2.4214478851744476`}, \
{-1.8071283500440232`, -2.0539095452111336`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.65618364739931, -2.81505323267394}, \
{-1.65618364739931, -2.4706079244040438`}}], 
          
          LineBox[{{-1.65618364739931, -2.4706079244040438`}, \
{-1.65618364739931, -2.1261626161341476`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.5040228008910033`, -2.875105173039695}, \
{-1.5040228008910033`, -2.5481456990090083`}}], 
          
          LineBox[{{-1.5040228008910033`, -2.5481456990090083`}, \
{-1.5040228008910033`, -2.2211862249783216`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.3539296288670801`, -2.956534168031409}, \
{-1.3539296288670801`, -2.6412677590483873`}}], 
          
          LineBox[{{-1.3539296288670801`, -2.6412677590483873`}, \
{-1.3539296288670801`, -2.326001350065366}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.2055237319284868`, -3.0030836819866935`}, \
{-1.2055237319284868`, -2.702590293800939}}], 
          
          LineBox[{{-1.2055237319284868`, -2.702590293800939}, \
{-1.2055237319284868`, -2.4020969056151844`}}]}}}}}, {{{}, {}, {}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005]], 
        LineBox[CompressedData["
1:eJw1lnk8VOsfx8dgGMvMWIcRIaKQe4VyLUe0SQqNxlLJVCoqIiVJlIokt5As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         "]]}}, {{
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
         PointSize[0.01], 
         Thickness[0.005]], 
        GeometricTransformationBox[
         InsetBox[
          BoxData[
           FormBox[
            StyleBox[
             GraphicsBox[{
               EdgeForm[], 
               DiskBox[{0, 0}]}], 
             GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                 AbsoluteThickness[1.6], 
                 RGBColor[
                 0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
                 PointSize[0.01], 
                 Thickness[0.005]]}, StripOnInput -> False], 
            TraditionalForm]], {0., 0.}, Automatic, 
          Offset[6.272]], CompressedData["
1:eJwBtQFK/iFib1JlAwAAABoAAAABAAAAAgAAAD4BDegb2RPAStwsfeTY97+c
3pFL0D8TwHUXrmbswfe/EgP70y6mEsBIiajh68H3v7UPTwkvCxLAMOrLpebX
/r8P4fIAcG8RwPFtuFwQp/i/HvoZ0zfTEMDXjukaMUj9v4B5/xSbORDAaRui
iQhH/b+kLkud4EEPwKU9iMh5YgDASBULkegMDsBAFlksYm8BwOu93gUU2AzA
S3mfOZJ3/r9RpY23wqYLwARlHLyBMAHABE57VAx1CsBNzMTBsLsAwHzM2vbm
QAnA2Xkmg26bAMCfmWtzAygIwP5EkqaHkwDAsImn70LeBsDlUxA8kwYAwIjl
N4bzhwXAPlWfLKSDAcC2NczWpW8EwNbobzQrigHALHKE+o9FA8BTxmmQMfEB
wPn/gB8aEgLAONbXmowmAsBghSCHqOAAwMQ14jg1tALAHladfIlT/7/yEHQV
xL8CwPrQsWr/6fy/R1eeESBfA8AhAJxsun/6vzNuZBbOwwPALD5kNnoQ+L93
flU2mmIEwMgcUR2yqfW/e7yo/VAhBcCf9LJA00nzv4Ll8qjnngXA2R/RJw==

         "]]}, {
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005]], 
        GeometricTransformationBox[
         TagBox[
          InsetBox["", {0., 0.}], "InsetString"], CompressedData["
1:eJw1lnk8VGscxmcGwwxmsQ2jhIhC7hXKLY5okxQajSVhKhUVKaWSVColuYVk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         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {-7.2705523451534315`, 0}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
         TagBox["\"Slope\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameStyle -> GrayLevel[0], 
     FrameTicks -> {{Automatic, Automatic}, {{{
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "4"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           
           TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000], -8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 3]], -8.111728083308073], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500], -7.824046010856292], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000], -7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000, 3]], -7.418580902748128], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 7]], -7.264430222920869], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250], -7.1308988302963465`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 9]], -7.013115794639964], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000], -8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 3]], -8.111728083308073], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500], -7.824046010856292], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000], -7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000, 3]], -7.418580902748128], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 7]], -7.264430222920869], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250], -7.1308988302963465`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 9]], -7.013115794639964], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[1, 0.75, 0], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.647624, 0.37816, 0.614037], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.571589, 0.586483, 0.], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.915, 0.3325, 0.2125], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[
          0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
          AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
       "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
       Scaled[0.05], "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> 
       True, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-7.2705523451534315`, 
       2.2795592420641055`}, {-4.080213821547785, 0}}, PlotRangeClipping -> 
     True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.02]}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"Binned data\"", "\"Platelets form factor fit\""}, 
      "PointLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.9372549019607843, 0.6470588235294118, 
                    0.6431372549019608], 
                    PointSize[0.5], 
                    Thickness[0.09]], {
                    InsetBox[
                    GraphicsBox[{
                    EdgeForm[], 
                    DiskBox[{0, 0}]}, {DefaultBaseStyle -> {"Graphics", {
                    AbsolutePointSize[6]}, 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.9372549019607843, 0.6470588235294118, 
                    0.6431372549019608], 
                    PointSize[0.5], 
                    Thickness[0.09]]}}], 
                    NCache[
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                    Scaled[{0.5, 0.5}]], Automatic, 
                    Scaled[1]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 6.272}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.28196428571428567`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09]], {
                    InsetBox[
                    FormBox[
                    StyleBox["\"\"", 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09]], FontSize -> 10, Plain, StripOnInput -> 
                    False], TraditionalForm], 
                    NCache[
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                    Scaled[{0.5, 0.5}]]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontSize -> 14, 
          GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.9372549019607843, 0.6470588235294118, 
                    0.6431372549019608]|>, "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}]}], "]"}]}], 
             "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    GraphicsBox[{
                    EdgeForm[], 
                    DiskBox[{0, 0}]}], ",", 
                    RowBox[{"Offset", "[", "6.272`", "]"}]}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"\"\"", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"False", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.8895182869567413`*^9, {3.8895183343905697`*^9, 3.8895183620551634`*^9}, {
   3.8895184150560637`*^9, 3.8895184418507495`*^9}, 3.8895185281220536`*^9, 
   3.8895889404320927`*^9, {3.8895890406246934`*^9, 3.8895890784682913`*^9}, 
   3.889592148098647*^9, 3.889592411520773*^9, 3.8895925734732924`*^9, 
   3.889592742450922*^9, 3.889592859727005*^9, 3.889592922507035*^9, 
   3.8895930087831736`*^9, 3.889668998234763*^9, 3.8896690890570593`*^9, 
   3.889669169286552*^9, 3.8896693168938737`*^9, 3.8896711091569824`*^9, 
   3.889671276253702*^9, 3.8896723301246977`*^9, 3.889677442821598*^9, 
   3.889677598100257*^9, 3.889684978194605*^9, 3.889685185804984*^9, 
   3.890204642630407*^9, 3.8902063323023443`*^9, 3.8902104829738626`*^9, 
   3.8902169904530506`*^9, 3.890217304571312*^9, 3.8902182374475017`*^9, 
   3.8909820692101192`*^9, 3.8909824066539817`*^9, 3.8909829558379273`*^9, 
   3.8914172809480352`*^9, 3.89141922718013*^9, 3.8914283344573555`*^9, 
   3.8926188577476263`*^9, 3.892619234655546*^9, 3.892628789917142*^9, 
   3.90231123633893*^9, 3.902311628948968*^9, 3.902312585907158*^9},
 CellLabel->
  "Out[1746]=",ExpressionUUID->"32fb43c4-d8cf-434e-bcfe-ee9ec85a4f29"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2022-08_\
new_data\\\\Analysis\\\\Full form factor fit\\\\LH-ESRF-C16 - volume (not \
corrupted)\\\\PlateletsSlopeFit.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.8895182869567413`*^9, {3.8895183343905697`*^9, 3.8895183620551634`*^9}, {
   3.8895184150560637`*^9, 3.8895184418507495`*^9}, 3.8895185281220536`*^9, 
   3.8895889404320927`*^9, {3.8895890406246934`*^9, 3.8895890784682913`*^9}, 
   3.889592148098647*^9, 3.889592411520773*^9, 3.8895925734732924`*^9, 
   3.889592742450922*^9, 3.889592859727005*^9, 3.889592922507035*^9, 
   3.8895930087831736`*^9, 3.889668998234763*^9, 3.8896690890570593`*^9, 
   3.889669169286552*^9, 3.8896693168938737`*^9, 3.8896711091569824`*^9, 
   3.889671276253702*^9, 3.8896723301246977`*^9, 3.889677442821598*^9, 
   3.889677598100257*^9, 3.889684978194605*^9, 3.889685185804984*^9, 
   3.890204642630407*^9, 3.8902063323023443`*^9, 3.8902104829738626`*^9, 
   3.8902169904530506`*^9, 3.890217304571312*^9, 3.8902182374475017`*^9, 
   3.8909820692101192`*^9, 3.8909824066539817`*^9, 3.8909829558379273`*^9, 
   3.8914172809480352`*^9, 3.89141922718013*^9, 3.8914283344573555`*^9, 
   3.8926188577476263`*^9, 3.892619234655546*^9, 3.892628789917142*^9, 
   3.90231123633893*^9, 3.902311628948968*^9, 3.9023125869222145`*^9},
 CellLabel->
  "Out[1747]=",ExpressionUUID->"cbc247ff-59bc-4979-a2b8-574efdb64353"],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJxM3Xc01v//x3FZaYeoJKOSQktUynXRLi20FBVp+dCQthQV0pCEBhpSWWVn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